package com.xebialabs.deployit.task.archive;

import java.util.List;

import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;

import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;

import static com.google.common.collect.Lists.newArrayList;

public class ArchivedStepBlock extends ArchivedAbstractBlock implements StepBlockState {

    private List<StepState> steps = newArrayList();

    @Override
    public int getCurrentStep() {
        return 0;
    }

    @Override
    public List<StepState> getSteps() {
        return steps;
    }

    public void setSteps(final List<StepState> steps) {
        this.steps = steps;
    }

    @Override
    public List<StepState> getStepList() {
        return steps;
    }

    @Override
    public StepState getStep(BlockPath path) {
        if (path.isLeaf()) {
            return steps.get(path.head() - 1);
        } else {
            throw new IllegalArgumentException("Leaf block but not leaf path");
        }
    }

    @Override
    public scala.Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply((Block) this);
        }
        throw new IllegalArgumentException("Leaf block but not leaf path");
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        BlockPath id = id();
        ListBuffer<Tuple2<BlockPath, StepState>> buffer = new ListBuffer<Tuple2<BlockPath, StepState>>();
        for (int i = 0; i < steps.size(); i++) {
            buffer.$plus$eq(new Tuple2<BlockPath, StepState>(id.newSubPath(i + 1), steps.get(i)));
        }
        return buffer;
    }
}
