package com.xebialabs.deployit.service.deployment;


import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import static java.util.Collections.unmodifiableList;
import static java.util.Collections.unmodifiableSet;
import static java.util.stream.Collectors.joining;

public final class GeneratedDeployeds {

    private final List<Deployed> deployeds;

    private final Set<String> unresolvedPlaceholders;

    public GeneratedDeployeds() {
        this(new ArrayList<>(), new HashSet<>());
    }

    private GeneratedDeployeds(List<Deployed> deployeds, Set<String> unresolvedPlaceholders) {
        this.deployeds = deployeds;
        this.unresolvedPlaceholders = unresolvedPlaceholders;
    }

    public List<Deployed> getDeployeds() {
        return unmodifiableList(deployeds);
    }


    public Set<String> getUnresolvedPlaceholders() {
        return unmodifiableSet(unresolvedPlaceholders);
    }

    public void addDeployed(Deployed deployed) {
        deployeds.add(deployed);
    }

    public void addUnresolvedPlaceholder(Set<String> placeholder) {
        unresolvedPlaceholders.addAll(placeholder);
    }

    public void merge(GeneratedDeployeds that) {
        this.deployeds.addAll(that.deployeds);
        this.unresolvedPlaceholders.addAll(that.unresolvedPlaceholders);
    }

    @Override
    public String toString() {
        return deployeds.stream().map(Deployed::getName).collect(joining(","));
    }
}
