package com.xebialabs.deployit.service

import com.xebialabs.deployit.booter.local.CiRoots
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Component

import scala.collection.convert.wrapAll._

@Component
@Lazy(false)
class ValidateAllowedRoots {

  val allowedRoots = Set("Applications", "Blueprints", "ProvisioningEnvironments", "Environments", "Infrastructure", "Configuration", "Providers")

  validateAllowedRoots()

  private def validateAllowedRoots(): Unit = {
    val validRoots = CiRoots.all().groupBy(allowedRoots)
    require(validRoots.get(false).isEmpty, s"Configuration item roots [${validRoots(false).mkString(", ")}] are not allowed")
  }
}
