package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState
import com.xebialabs.deployit.jcr.JcrUtils.getProperty
import com.xebialabs.deployit.task.archive.BlockType.PHASE_BLOCK
import com.xebialabs.deployit.task.archive.NodeNames._

object PhaseReader {
  def unapply(blockNode: Node): Option[PhaseReader] = if (blockNode.hasProperty(BLOCK_TYPE) && getProperty(blockNode, BLOCK_TYPE).equals(PHASE_BLOCK.name()))
    Some(new PhaseReader)
  else None
}

class PhaseReader extends BlockReader {

  override def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): ArchivedPhase = {
    val underlyingBlockNode = blockNode.getNodes.nextNode()
    val underlyingBlock = BlockReader(underlyingBlockNode).read(underlyingBlockNode, loadSteps, uptodateModel).asInstanceOf[ArchivedAbstractBlock]

    val phase = new ArchivedPhase(underlyingBlock)

    readBasicBlockProperties(blockNode, phase, uptodateModel)

    phase
  }

  override def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer = {
    val phase = read(taskNode, loadSteps, BlockReader.DEPRECATED_MODEL)
    val container = new ArchivedPhaseContainer(java.util.Arrays.asList(phase))
    container.setState(BlockExecutionState.STOPPED)
    container.setDescription("")

    container
  }
}