package com.xebialabs.deployit.task.archive

object EnvironmentId {

  def encode(id: String): EnvironmentId = {
    val correctedId = if (id.startsWith(ENVIRONMENTS_ROOT))
      id.substring(ENVIRONMENTS_ROOT.length)
    else id

    correctedId.replace("/", "$#")
  }

  def decode(id: String): EnvironmentId = {
    val converted = id.replace("$#", "/")

    if (!id.startsWith(ENVIRONMENTS_ROOT)) {
      ENVIRONMENTS_ROOT + converted

    } else converted

  }

  val ENVIRONMENTS_ROOT = "Environments/"

}