package com.xebialabs.deployit.task.archive;

import java.util.List;
import com.google.common.base.Function;

import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;

import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;

import static com.google.common.collect.FluentIterable.from;

public class ArchivedPhaseContainer extends ArchivedAbstractBlock implements PhaseContainerState {

    public final List<ArchivedPhase> phases;

    public ArchivedPhaseContainer(List<ArchivedPhase> phases) {
        this.phases = phases;
    }

    @Override
    public List<StepState> getStepList() {
        return from(phases)
                .transformAndConcat(new Function<ArchivedPhase, Iterable<StepState>>() {
                    @Override
                    public Iterable<StepState> apply(ArchivedPhase input) {
                        return input.getStepList();
                    }
                }).toList();
    }

    @Override
    public StepState getStep(BlockPath path) {
        int head = path.head();
        return (phases.get(head - 1)).getStep(path.tail());

    }

    @Override
    public Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply((Block) this);
        }
        int head = path.head();
        return phases.get(head - 1).getBlock(path.tail());
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        scala.collection.mutable.ListBuffer<Tuple2<BlockPath, StepState>> swp = new ListBuffer<>();
        for (ArchivedPhase phase : phases) {
            swp.append(phase.getStepsWithPaths());
        }
        return swp;
    }

    @Override
    public Iterable<PhaseState> getBlocks() {
        return from(phases).transform(new Function<ArchivedPhase, PhaseState>() {
            @Override
            public PhaseState apply(ArchivedPhase input) {
                return input;
            }
        }).toList();

    }
}
