package com.xebialabs.deployit.service.version.exporter;


import com.xebialabs.deployit.packager.writers.ManifestXmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.local.LocalFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

@Component
public class ExporterService {

    private final RepositoryService repositoryService;

    @Autowired
    public ExporterService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public LocalFile exportDar(String versionId, final WorkDir workDir) {
        checkNotNull(versionId, "id of the version to be exported is null");

        ConfigurationItem ci = repositoryService.read(versionId, workDir);
        checkArgument(ci.getType().instanceOf(Type.valueOf(DistributionVersion.class)), "Expected a subtype of udm.Version for exporting but got %s", ci.getType());

        File targetDir = new File(workDir.getPath());
        com.xebialabs.deployit.packager.DarPackager darPackager = new com.xebialabs.deployit.packager.DarPackager(new ManifestXmlWriter());
        return (LocalFile) LocalFile.valueOf(darPackager.buildPackage((DistributionVersion) ci, targetDir.getAbsolutePath()).getFile());
    }
}
