package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

class PropertyResolverDeployedGenerator extends AbstractChainGenerator {

    private final Logger logger = LoggerFactory.getLogger(PropertyResolverDeployedGenerator.class);

    public PropertyResolverDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedPropertySetter deployedPropertySetter = deploymentContext.getBeanSupplier().getBean(DeployedPropertySetter.class);
        Set<String> unresolvedPlaceholders = new HashSet<>();
        GeneratedDeployeds generatedDeployeds = nextGenerator.generateDeployed(deploymentContext, deployable, container);
        generatedDeployeds.getDeployeds().stream().forEach(d -> deployedPropertySetter.setProperties(
                d,
                deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container).orElse(null),
                deploymentContext.dictionaryFilteredByContainer(container), unresolvedPlaceholders)
        );
        generatedDeployeds.addUnresolvedPlaceholder(unresolvedPlaceholders);
        logger.debug("'{}' generated following deployeds [{}]", nextGenerator.getClass().getName(), generatedDeployeds);
        return generatedDeployeds;
    }
}
