package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.plugin.api.xld.Domain;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

@Component
public class DeployedApplicationFactory {

    private final DeployedPropertySetter deployedPropertySetter;

    @Autowired
    public DeployedApplicationFactory(DeployedPropertySetter deployedPropertySetter) {
        this.deployedPropertySetter = deployedPropertySetter;
    }

    public AppliedDistribution createDeployedApplication(Type deployedApplicationType, final DistributionVersion pkg, final Domain env, ConsolidatedDictionary dictionary, Set<String> missingPlaceholdersAggregator) {
        Descriptor deployedApplicationDescriptor = DescriptorRegistry.getDescriptor(deployedApplicationType);
        String id = generateId(env, pkg.getDistribution().getId());
        AppliedDistribution deployedApplication = deployedApplicationDescriptor.newInstance(id);
        deployedApplication.setVersion(pkg);
        deployedApplication.setEnvironment(env);
        deployedPropertySetter.setProperties(deployedApplication, null, dictionary, missingPlaceholdersAggregator);
        return deployedApplication;
    }

    public DeployedApplication createUpgradeDeployedApplication(Version newVersion, DeployedApplication deployedApplication, ConsolidatedDictionary dictionary, Set<String> missingPlaceholdersAggregator) {
        Descriptor deployedApplicationDescriptor = DescriptorRegistry.getDescriptor(Type.valueOf(DeployedApplication.class));
        DeployedApplication newDeployedApplication = deployedApplicationDescriptor.newInstance(deployedApplication.getId());
        newDeployedApplication.setEnvironment(deployedApplication.getEnvironment());
        newDeployedApplication.setVersion(newVersion);
        deployedPropertySetter.setProperties(newDeployedApplication, deployedApplication, dictionary, missingPlaceholdersAggregator);
        return newDeployedApplication;
    }

    public void scanMissingPlaceholders(DeployedApplication deployedApplication, Environment environment, Set<String> missingPlaceholdersAggregator) {
        deployedPropertySetter.setProperties(deployedApplication, null, Dictionaries.of(environment.getDictionaries()).consolidate(), missingPlaceholdersAggregator);
    }

    @SuppressWarnings("serial")
    @HttpResponseCodeResult(statusCode = 400)
    public static class IncorrectDeployedException extends DeployitException {
        IncorrectDeployedException(Throwable cause, String messageTemplate, Object... params) {
            super(cause, messageTemplate, params);
        }
    }

}
