package com.xebialabs.deployit.repository

import java.io.InputStream
import javax.jcr.{Credentials, SimpleCredentials}

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.repository.{RepositoryConfigurationSource, XlRepositoryConfig}
import org.springframework.beans.factory.FactoryBean
import org.springframework.beans.factory.annotation.Autowired

import scala.beans.BeanProperty

class XlRepositoryConfigFactoryBean extends FactoryBean[XlRepositoryConfig]{

  @Autowired @BeanProperty var serverConfig: ServerConfiguration = _

  override def getObject: XlRepositoryConfig = {
    new XlRepositoryConfig {
      override def jcrRepositoryConfig: RepositoryConfigurationSource = new RepositoryConfigurationSource("jackrabbit-repository.xml")
      override def repositoryName: String = "xl-deploy"
      override def repositoryVersion: Version = Version.valueOf("xl-deploy", Version.VERSION_0)
      override def repositoryId: Option[String] = None
      override def credentials: Option[_ <: Credentials] = Some(new SimpleCredentials("admin", serverConfig.getAdminPasswordSupplier.get()))
    }
  }

  override def getObjectType: Class[_] = classOf[XlRepositoryConfig]

  override def isSingleton: Boolean = true

}
