package com.xebialabs.deployit.repository;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.checks.Checks.IncorrectArgumentException;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

@Component("deployitJcrRepositoryService")
public class DeployitJcrRepositoryService extends JcrRepositoryService {

    @Autowired
    public DeployitJcrRepositoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter, LicenseService licenseService) {
        super(jcrTemplate, passwordEncrypter, licenseService);
    }

    /**
     * Only allows moving of {@link Directory Directories}  and 'rooted' CIs.
     *
     *  @throws IncorrectArgumentException if the type can't be moved.
     */
    @Override
    protected void checkMoveAllowed(Type type) {
        if (!type.equals(Type.valueOf(Directory.class))) {
            checkArgument(!DescriptorRegistry.getDescriptor(type).getRoot().equals(Metadata.ConfigurationItemRoot.NESTED), "Can only move 'rooted' cis [%s]", type);
        }
    }

    /**
     * Only allows moving of CIs to a new parent that is of the exact same type as the original parent.
     *
     *  @throws IncorrectArgumentException if the type can't be copied.
     */
    protected void checkCopyAllowed(Session session, String toBeCopied, String newId) throws RepositoryException {
        Type toBeCopiedParentType = readType(session, extractParentId(toBeCopied));
        Type newParentType = readType(session, extractParentId(newId));
        checkArgument(toBeCopiedParentType.equals(newParentType), "Target parent of copied ci must be of same type as that of the copied item [%s]", toBeCopiedParentType);
    }

}
