/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.deployment.planner.MultiDeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Plans;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.service.deployment.ImprovedPartialCommitTrigger;
import com.xebialabs.deployit.service.deployment.ReferentialIntegrityTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="deploymentService")
public class DeploymentService {
    private final MultiDeploymentPlanner planner;
    private RepositoryAdapterFactory repositoryFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(MultiDeploymentPlanner planner, RepositoryAdapterFactory repositoryFactory) {
        this.planner = planner;
        this.repositoryFactory = repositoryFactory;
    }

    public MultiDeltaSpecification prepareInitialSpecification(Deployment deployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        return MultiDeltaSpecification.withDependencies((DeltaSpecification)this.prepareInitialSpecification(deployment), this.prepareDependencyDeployments(deployment.getRequiredDeployments(), existingDepoyedApplications));
    }

    private DeltaSpecification prepareInitialSpecification(Deployment deployment) {
        return this.prepareInitialSpecification(DeploymentService.extractDeployedApplicationWithDeployeds(deployment));
    }

    DeltaSpecification prepareInitialSpecification(AppliedDistribution deployedApplication) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, Sets.newHashSet(), deployedApplication.getDeployeds());
        return builder.build();
    }

    public MultiDeltaSpecification prepareUpgradeSpecification(Deployment deployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        return MultiDeltaSpecification.withDependencies((DeltaSpecification)this.prepareUpgradeSpecification(deployment, existingDepoyedApplications.get(deployment.getDeployedApplication().getId())), this.prepareDependencyDeployments(deployment.getRequiredDeployments(), existingDepoyedApplications));
    }

    private DeltaSpecification prepareUpgradeSpecification(Deployment deployment, DeployedApplication existingDeployedApplication) {
        return this.prepareUpgradeSpecification(DeploymentService.extractDeployedApplicationWithDeployeds(deployment), existingDeployedApplication);
    }

    DeltaSpecification prepareUpgradeSpecification(AppliedDistribution newDeployedApplication, DeployedApplication existingDeployedApplication) {
        this.copyTransientProperties(newDeployedApplication, existingDeployedApplication);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().upgrade((AppliedDistribution)existingDeployedApplication, newDeployedApplication);
        logger.trace("Incoming Deployeds {}", (Object)newDeployedApplication.getDeployeds());
        logger.trace("Existing Deployeds {}", (Object)existingDeployedApplication.getDeployeds());
        DeploymentOperationCalculator.calculate(builder, existingDeployedApplication.getDeployeds(), newDeployedApplication.getDeployeds());
        return builder.build();
    }

    private List<DeltaSpecification> prepareDependencyDeployments(List<Deployment> requiredDeployments, Map<String, DeployedApplication> existingDepoyedApplications) {
        return Lists.newArrayList((Iterable)Iterables.transform(requiredDeployments, input -> this.prepareDependencyDeployment((Deployment)input, existingDepoyedApplications)));
    }

    private DeltaSpecification prepareDependencyDeployment(Deployment requiredDeployment, Map<String, DeployedApplication> existingDepoyedApplications) {
        switch (requiredDeployment.getDeploymentType()) {
            case INITIAL: {
                return this.prepareInitialSpecification(requiredDeployment);
            }
            case UPDATE: {
                return this.prepareUpgradeSpecification(requiredDeployment, existingDepoyedApplications.get(requiredDeployment.getDeployedApplication().getId()));
            }
        }
        throw new IllegalArgumentException("Deployment " + requiredDeployment.getId() + " has invalid type " + requiredDeployment.getDeploymentType());
    }

    private static AppliedDistribution extractDeployedApplicationWithDeployeds(Deployment deployment) {
        AppliedDistribution deployedApp = (AppliedDistribution)deployment.getDeployedApplication();
        deployedApp.addDeployeds(DeploymentService.getDeployeds(deployment));
        return deployedApp;
    }

    private static HashSet<Deployed> getDeployeds(Deployment deployment) {
        List deployedEntities = deployment.getDeployeds();
        FluentIterable from = FluentIterable.from((Iterable)deployedEntities);
        Checks.checkArgument((boolean)from.allMatch(Predicates.or((Predicate)Predicates.instanceOf(Deployed.class), (Predicate)Predicates.instanceOf(EmbeddedDeployed.class))), (String)"The Deployment can only contain Deployed or EmbeddedDeployed configuration items", (Object[])new Object[0]);
        return Sets.newHashSet((Iterable)from.filter(Deployed.class));
    }

    private void copyTransientProperties(AppliedDistribution newDeployment, DeployedApplication existingDeployment) {
        Descriptor descriptor = newDeployment.getType().getDescriptor();
        logger.debug("Copying transient properties to previous deployed application for {}", (Object)newDeployment.getId());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!pd.isTransient()) {
                logger.trace("Skipping copy of non-transient property {}", (Object)pd.getFqn());
                continue;
            }
            if (pd.get((ConfigurationItem)newDeployment) == null || pd.get((ConfigurationItem)existingDeployment) != null) {
                logger.trace("Skipping copy of property {} as it is either not set on 'new', or already set on 'existing'", (Object)pd.getFqn());
                continue;
            }
            logger.debug("Copying transient property {} to existing deployment", (Object)pd.getFqn());
            pd.set((ConfigurationItem)existingDeployment, pd.get((ConfigurationItem)newDeployment));
        }
    }

    public MultiDeltaSpecification prepareUndeployment(AppliedDistribution deployedApplication) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, deployedApplication.getDeployeds(), Sets.newHashSet());
        return new MultiDeltaSpecification(builder.build());
    }

    TaskSpecification getTaskSpecification(DeltaSpecification deltaSpecification, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        return this.getTaskFullSpecification(new MultiDeltaSpecification(deltaSpecification), currentWorkDir, workdirsToCleanup);
    }

    public TaskSpecification getTaskFullSpecification(MultiDeltaSpecification spec, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        TaskSpecification taskSpec = null;
        switch (spec.getMainOperation()) {
            case CREATE: {
                taskSpec = this.getTaskSpecification("Initial deployment of " + spec.getMainDeployedApplication().getId(), spec, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, spec.getMainDeployedApplication(), TaskType.INITIAL);
                break;
            }
            case DESTROY: {
                taskSpec = this.getTaskSpecification("Undeployment of " + spec.getMainPreviousDeployedApplication().getId(), spec, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, spec.getMainPreviousDeployedApplication(), TaskType.UNDEPLOY);
                break;
            }
            case MODIFY: {
                String description = "Update deployment of " + spec.getMainPreviousDeployedApplication().getId();
                taskSpec = this.getTaskSpecification(description, spec, currentWorkDir, workdirsToCleanup);
                DeploymentService.addMetadata(taskSpec, spec.getMainDeployedApplication(), TaskType.UPGRADE);
                break;
            }
        }
        return taskSpec;
    }

    private TaskSpecification getTaskSpecification(String description, MultiDeltaSpecification specification, WorkDir currentWorkDir, WorkDir ... workdirsToCleanup) {
        DeploymentService.unsetTokensForRealityPush(specification);
        PhasedPlan plan = this.planner.plan(specification, this.repositoryFactory.create(new File(currentWorkDir.getPath())));
        String taskId = UUID.randomUUID().toString();
        logger.info("Generated plan for task {}:\n{}", (Object)taskId, (Object)plan.writePlan((Writer)new StringWriter()));
        PhaseContainer executionBlock = Plans.toBlockBuilder((PhasedPlan)plan).build();
        TaskSpecification spec = new TaskSpecification(taskId, description, Permissions.getAuthentication(), currentWorkDir, executionBlock, null, true, true);
        spec.getListeners().addAll(plan.getListeners());
        ArrayList workDirs = Lists.newArrayList((Object[])workdirsToCleanup);
        workDirs.add(currentWorkDir);
        spec.getListeners().add(new WorkdirCleanerTrigger((List)workDirs));
        spec.getListeners().add(new ReferentialIntegrityTrigger(specification));
        spec.getListeners().add(this.createPartialCommitTrigger(specification, (Plan)plan));
        this.addTaskRefs(specification, spec);
        return spec;
    }

    private void addTaskRefs(MultiDeltaSpecification specification, TaskSpecification spec) {
        Iterable dependantSpecs = specification.getDeltaSpecifications().stream().filter(input -> !specification.getMainDeltaSpecification().equals(input)).collect(Collectors.toList());
        Iterable dependencies = Iterables.transform((Iterable)dependantSpecs, (Function)new Function<DeltaSpecification, TaskPackageDependency>(){

            AppliedDistribution deployedApplication(DeltaSpecification spec) {
                if (spec.getAppliedDistribution() != null) {
                    return spec.getAppliedDistribution();
                }
                return spec.getPreviousAppliedDistribution();
            }

            @Nullable
            public TaskPackageDependency apply(DeltaSpecification input) {
                AppliedDistribution app = this.deployedApplication(input);
                return new TaskPackageDependency(app.getName(), app.getVersion().getVersion());
            }
        });
        for (TaskPackageDependency dependency : dependencies) {
            spec.getPackageDependencies().add(dependency);
        }
    }

    protected ExecutionStateListener createPartialCommitTrigger(MultiDeltaSpecification specification, Plan plan) {
        return new ImprovedPartialCommitTrigger(specification, plan.findCheckpoints());
    }

    private static void unsetTokensForRealityPush(MultiDeltaSpecification fullSpec) {
        for (AppliedDistribution deployedApplication : fullSpec.getAllDeployedApplications()) {
            deployedApplication.set$token(null);
        }
        for (Delta delta : fullSpec.getAllDeltas()) {
            Deployed ci = delta.getDeployed();
            DeploymentService.unsetTokenOnCi((ConfigurationItem)ci);
        }
    }

    private static void unsetTokenOnCi(ConfigurationItem ci) {
        if (ci instanceof BaseConfigurationItem) {
            BaseConfigurationItem bci = (BaseConfigurationItem)ci;
            bci.set$token(null);
            DeploymentService.unsetTokensOnEmbeddeds(bci);
        }
    }

    private static void unsetTokensOnEmbeddeds(BaseConfigurationItem deployed) {
        Collection propertyDescriptors = deployed.getType().getDescriptor().getPropertyDescriptors();
        Collection embeddedProperties = Collections2.filter((Collection)propertyDescriptors, (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.isAsContainment() && EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(input.getKind()) && input.getReferencedType().instanceOf(Type.valueOf(EmbeddedDeployed.class));
            }
        });
        for (PropertyDescriptor embeddedProperty : embeddedProperties) {
            Collection c = (Collection)embeddedProperty.get((ConfigurationItem)deployed);
            for (ConfigurationItem configurationItem : c) {
                DeploymentService.unsetTokenOnCi(configurationItem);
            }
        }
    }

    private static void addMetadata(TaskSpecification spec, AppliedDistribution deployedApp, TaskType taskType) {
        TaskMetadata.putMetadata(spec, "environment_id", deployedApp.getEnvironment().getId());
        TaskMetadata.putMetadata(spec, "environment", deployedApp.getEnvironment().getName());
        TaskMetadata.putMetadata(spec, "version", deployedApp.getVersion().getName());
        TaskMetadata.putMetadata(spec, "application", deployedApp.getVersion().getDistribution().getName());
        TaskMetadata.putMetadata(spec, "taskType", taskType.name());
    }

    private static List<StepState> asTaskSteps(StepPlan plan) {
        return Lists.newArrayList((Iterable)Lists.transform((List)plan.getStepsWithPlanningInfo(), input -> {
            TaskStep taskStep = new TaskStep(input.getStep());
            int i = 0;
            taskStep.getMetadata().put("order", Integer.toString(input.getStep().getOrder()));
            taskStep.getMetadata().put("previewAvailable", Boolean.toString(input.getStep() instanceof PreviewStep));
            taskStep.getMetadata().put("rule", input.getRule());
            for (Delta delta : input.getDeltas()) {
                taskStep.getMetadata().put("deployed_" + i++, DeploymentService.getActiveDeployed(delta).getId());
            }
            return taskStep;
        }));
    }

    private static Deployed getActiveDeployed(Delta delta) {
        return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
    }
}

