/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.FileWithoutContent;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeReader {
    private Session session;
    private Node node;
    private final WorkDir workDir;
    private NodeReaderContext context;
    private static final Logger logger = LoggerFactory.getLogger(NodeReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ConfigurationItem> T read(Session session, Node node, WorkDir workDir) throws RepositoryException {
        NodeReaderContext c = NodeReaderContext.get().hold();
        try {
            T t = new NodeReader(session, node, workDir, c).read();
            return t;
        }
        finally {
            c.release();
        }
    }

    private NodeReader(Session session, Node node, WorkDir workDir, NodeReaderContext context) {
        this.session = session;
        this.node = node;
        this.workDir = workDir;
        this.context = context;
    }

    private <T extends ConfigurationItem> T read() throws RepositoryException {
        String id = JcrPathHelper.getIdFromAbsolutePath(this.node.getPath());
        logger.trace("{} loading with workdir {}", (Object)id, (Object)this.workDir);
        if (this.context.hasItem(this.node.getIdentifier())) {
            ConfigurationItem item = this.context.get(this.node.getIdentifier());
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null && ((SourceArtifact)item).getFile() instanceof FileWithoutContent) {
                this.copyData(item, descriptor);
            } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && ((DerivedArtifact)item).getFile() == null) {
                this.copyData(item, descriptor);
            }
            return (T)item;
        }
        Type type = Type.valueOf((String)this.node.getProperty("$configuration.item.type").getString());
        if (!type.exists()) {
            logger.warn("While trying to read node [{}] its type [{}] was not found in any plugin. Please make sure the required plugin is installed.", (Object)this.node.getPath(), (Object)type);
            throw new RepositoryException(String.format("Unknown type [%s] while reading node [%s]", type, this.node.getPath()));
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem item = descriptor.newInstance();
        item.setId(id);
        this.context.put(this.node.getIdentifier(), item);
        this.copyValues(item, descriptor);
        this.copyData(item, descriptor);
        return (T)item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigurationItem> void copyData(T item, Descriptor descriptor) throws RepositoryException {
        DerivedArtifact d;
        if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null) {
            LocalFile localFile;
            block16: {
                String filename = this.node.getProperty("$filename").getString();
                localFile = this.workDir.newFile(filename);
                Binary binary = this.node.getProperty("$data").getBinary();
                try {
                    logger.debug("Reading Source Artifact {} of type {} data. " + item.getId(), (Object)descriptor);
                    if (descriptor.isAssignableTo(FolderArtifact.class)) {
                        localFile.mkdir();
                        try {
                            Exploder.explode(this.createInputSupplier(binary), localFile.getFile());
                            break block16;
                        }
                        catch (IOException e) {
                            throw new RuntimeIOException("Could not extract data from " + item.getId() + " to directory " + localFile.getPath(), e);
                        }
                    }
                    OutputStream outputStream = localFile.getOutputStream();
                    try {
                        ByteStreams.copy(this.createInputSupplier(binary), (OutputStream)outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Could not copy data from " + item.getId() + " to file " + localFile.getPath(), e);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)outputStream);
                    }
                }
                finally {
                    binary.dispose();
                }
            }
            ((Artifact)item).setFile((OverthereFile)localFile);
        } else if (descriptor.isAssignableTo(SourceArtifact.class)) {
            String filename = this.node.getProperty("$filename").getString();
            ((Artifact)item).setFile((OverthereFile)new FileWithoutContent(filename));
        } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && (d = (DerivedArtifact)item).getSourceArtifact() != null) {
            d.setFile((OverthereFile)DerivedArtifactFile.create(d));
        }
    }

    private InputSupplier<InputStream> createInputSupplier(final Binary binary) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return binary.getStream();
                }
                catch (RepositoryException e) {
                    throw new IOException("Could not get inputstream from node.");
                }
            }
        };
    }

    private <T extends ConfigurationItem> void copyValues(T item, Descriptor descriptor) throws RepositoryException {
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!this.node.hasProperty(pd.getName()) && !pd.isAsContainment()) {
                logger.trace("Repository node [{}] does not contain value for (non-containment) property [{}]. Using the default value.", (Object)item.getId(), (Object)pd);
                continue;
            }
            if (pd.isTransient()) {
                if (this.node.hasProperty(pd.getName())) {
                    logger.warn("Repository node [{}] contains transient property [{}] which should not have been persisted.", (Object)item.getId(), (Object)pd);
                }
                logger.trace("Not attempting to read transient property [{}] from repository node [{}]. Using the default value.", (Object)pd, (Object)item.getId());
                continue;
            }
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.setPrimitiveProperty(item, pd);
                    break;
                }
                case SET_OF_STRING: {
                    pd.set(item, (Object)Sets.newHashSet(this.getCollectionOfStringValues(item, pd)));
                    break;
                }
                case SET_OF_CI: {
                    pd.set(item, (Object)Sets.newHashSet(this.getCollectionOfConfigurationItemValues(item, pd)));
                    break;
                }
                case LIST_OF_STRING: {
                    pd.set(item, (Object)Lists.newArrayList(this.getCollectionOfStringValues(item, pd)));
                    break;
                }
                case LIST_OF_CI: {
                    pd.set(item, (Object)Lists.newArrayList(this.getCollectionOfConfigurationItemValues(item, pd)));
                    break;
                }
                case CI: {
                    this.setConfigurationItemProperty(item, pd);
                    break;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyFromNode(item, pd);
                }
            }
        }
    }

    private <T extends ConfigurationItem> void copyMapPropertyFromNode(T item, PropertyDescriptor pd) throws RepositoryException {
        Property property = this.node.getProperty(pd.getName());
        pd.set(item, JcrUtils.readMap(property));
    }

    private <T extends ConfigurationItem> void setConfigurationItemProperty(T item, PropertyDescriptor pd) throws RepositoryException {
        Node referencedNode;
        if (pd.isAsContainment()) {
            referencedNode = this.node.getParent();
        } else {
            Value value = this.node.getProperty(pd.getName()).getValue();
            referencedNode = NodeUtils.getReferencedCiNode(this.node, value, this.session);
        }
        pd.set(item, NodeReader.read(this.session, referencedNode, this.workDir));
    }

    private <T extends ConfigurationItem> Collection<ConfigurationItem> getCollectionOfConfigurationItemValues(T item, PropertyDescriptor pd) throws RepositoryException, InvalidQueryException, ValueFormatException, PathNotFoundException {
        ArrayList items = Lists.newArrayList();
        if (pd.isAsContainment()) {
            SearchParameters params = new SearchParameters().setParent(item.getId()).setType(pd.getReferencedType());
            SearchQueryBuilder builder = new SearchQueryBuilder(params);
            Query query = builder.build(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node referencedNode = iterator.nextNode();
                items.add(NodeReader.read(this.session, referencedNode, this.workDir));
            }
        } else {
            for (Value each : this.node.getProperty(pd.getName()).getValues()) {
                Node referencedNode = NodeUtils.getReferencedCiNode(this.node, each, this.session);
                items.add(NodeReader.read(this.session, referencedNode, this.workDir));
            }
        }
        return items;
    }

    private <T extends ConfigurationItem> Collection<String> getCollectionOfStringValues(T item, PropertyDescriptor pd) throws ValueFormatException, RepositoryException, PathNotFoundException {
        ArrayList list = Lists.newArrayList();
        for (Value v : this.node.getProperty(pd.getName()).getValues()) {
            list.add(v.getString());
        }
        return list;
    }

    private <T extends ConfigurationItem> void setPrimitiveProperty(T item, PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = this.node.getProperty(pd.getName()).getString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = PasswordObfuscator.ensureDecrypted(valueAsString);
        }
        pd.set(item, (Object)valueAsString);
    }
}

