package com.xebialabs.deployit.task;

import static com.google.common.collect.Lists.newArrayList;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;

@SuppressWarnings("serial")
public abstract class DeploymentTask extends Task {

	private ArrayList<WorkDir> workDirs = newArrayList();

	public enum DeploymentType { INITIAL, UPGRADE, UNDEPLOY, UNKNOWN }

    protected final transient RepositoryService repositoryService;

	private String applicationName;

    private String applicationVersion;

    private String environment;

    public DeploymentTask(final List<? extends DeploymentStep> steps, final RepositoryService repositoryService, final WorkDir... workDirs) {
        super(steps);
        this.repositoryService = repositoryService;
	    if (workDirs != null) this.workDirs = newArrayList(workDirs);
    }

	protected DeploymentTask(final List<TaskStep> steps, final State state) {
		this(new StepList(steps, steps.size()), state);
	}

    DeploymentTask(final StepList stepList, State state) {
        super(stepList,state);
        this.repositoryService = null;
    }

    /**
	 * Destroys a task. Cleans up any temporary files needed for execution of the task.
	 */
	public void destroy() {
		for (WorkDir workDir : workDirs) {
			workDir.delete();
		}
        super.destroy();
	}

    protected void initFromDeployment(final DeployedApplication deployment ) {
        this.setApplicationName(deployment.getVersion().getApplication().getName());
        this.setApplicationVersion(deployment.getVersion().getVersion());
        this.setEnvironment(deployment.getEnvironment().getId());
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public abstract DeploymentType getDeploymentType();
}
