package com.xebialabs.deployit.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.OverthereFile;

public class Imploder {

	public static byte[] implode(OverthereFile folder) throws IOException {
		final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		final ZipOutputStream zipper = new ZipOutputStream(outputStream);
		try {
			for (OverthereFile file : folder.listFiles()) {
				writeEntry(zipper, file, "");
			}
		} finally {
			zipper.close();
		}

		return outputStream.toByteArray();
	}

	private static void writeEntry(final ZipOutputStream zipper, final OverthereFile file, String path) throws IOException {
		if (file.isDirectory()) {
			zipper.putNextEntry(new ZipEntry(path + file.getName() + "/"));
			writeDirectoryContents(zipper, file, path);
		} else {
			final ZipEntry zipEntry = new ZipEntry(path + file.getName());
			zipper.putNextEntry(zipEntry);
			InputStream inputStream = file.getInputStream();
			try {
				ByteStreams.copy(inputStream, zipper);
			} finally {
				Closeables.closeQuietly(inputStream);
			}
			zipper.closeEntry();
		}
	}

	private static void writeDirectoryContents(final ZipOutputStream zipper, final OverthereFile folder, String path) throws IOException {
		for (OverthereFile file : folder.listFiles()) {
			writeEntry(zipper, file, path + folder.getName() + "/");
		}
	}
}
