/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.jcrarchive;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;

public class JcrArchivedTaskSearchQueryBuilder
extends ArchivedTaskSearchParameters {
    private ValueFactory vf;
    private QueryObjectModelFactory qf;
    static final String TASK_SELECTOR_NAME = "task";

    public JcrArchivedTaskSearchQueryBuilder(QueryManager qm, ValueFactory vf, ArchivedTaskSearchParameters p) {
        super(p);
        this.vf = vf;
        this.qf = qm.getQOMFactory();
    }

    public QueryObjectModel buildQuery() throws RepositoryException {
        ArrayList andConstraints = Lists.newArrayList();
        this.appendTaskUuidCriteria(andConstraints);
        this.appendEnvironmentApplicationAndVersionCriteria(andConstraints);
        this.appendExecutedByCriteria(andConstraints);
        this.appendStatusCriteria(andConstraints);
        this.appendDateRangeCriteria(andConstraints);
        Selector selector = this.qf.selector("deployit:task", TASK_SELECTOR_NAME);
        return this.qf.createQuery((Source)selector, this.createSingleAndConstraint(andConstraints), null, null);
    }

    private void appendTaskUuidCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.isNotBlank(this.taskUuid)) {
            constraints.add(this.equalConstraint("$id", this.taskUuid));
        }
    }

    private boolean isNotBlank(String s) {
        return !Strings.nullToEmpty((String)s).trim().isEmpty();
    }

    private void appendEnvironmentApplicationAndVersionCriteria(List<Constraint> constraints) throws RepositoryException {
        StringBuilder descendentOf = new StringBuilder("/tasks");
        boolean applicationInDescendentPath = false;
        boolean versionInDescendentPath = false;
        if (this.isNotBlank(this.environment)) {
            descendentOf.append("/").append(JcrTaskArchive.encodeEnvironmentId(this.environment));
            if (this.isNotBlank(this.application)) {
                applicationInDescendentPath = true;
                descendentOf.append("/").append(this.application);
                if (this.isNotBlank(this.version)) {
                    versionInDescendentPath = true;
                    descendentOf.append("/").append(this.version);
                }
            }
        }
        if (!applicationInDescendentPath && this.isNotBlank(this.application)) {
            constraints.add(this.equalConstraint("application", this.application));
        }
        if (!versionInDescendentPath && this.isNotBlank(this.version)) {
            constraints.add(this.equalConstraint("version", this.version));
        }
        constraints.add((Constraint)this.qf.descendantNode(TASK_SELECTOR_NAME, descendentOf.toString()));
    }

    private void appendExecutedByCriteria(List<Constraint> constraints) throws RepositoryException {
        if (this.isNotBlank(this.executedBy)) {
            constraints.add(this.equalConstraint("ownerUser", this.executedBy));
        }
    }

    private void appendStatusCriteria(List<Constraint> constraints) throws RepositoryException {
        switch (this.status) {
            case COMPLETED: {
                constraints.add((Constraint)this.qf.and(this.equalConstraint("state", Task.State.DONE.name()), this.equalConstraint("failureCount", 0L)));
                break;
            }
            case CANCELLED: {
                constraints.add(this.equalConstraint("state", Task.State.CANCELLED.name()));
                break;
            }
            case COMPLETED_AFTER_RETRY: {
                Constraint stateConstraint = this.equalConstraint("state", Task.State.DONE.name());
                Constraint failureConstraint = this.greaterThanConstraint("failureCount", 0L);
                constraints.add((Constraint)this.qf.and(stateConstraint, failureConstraint));
            }
        }
    }

    private void appendDateRangeCriteria(List<Constraint> constraints) throws RepositoryException {
        switch (this.dateRangeSearch) {
            case AFTER: {
                Calendar startDateAsCal = this.cloneAndSetTimeToStartOfDay(this.startDate);
                constraints.add(this.greaterThanOrEqualConstraint("startDate", startDateAsCal));
                break;
            }
            case BEFORE: {
                Calendar endDateAsCal = this.cloneAndSetTimeToEndOfDay(this.endDate);
                constraints.add(this.lessThanOrEqualConstraint("startDate", endDateAsCal));
                break;
            }
            case BETWEEN: {
                Calendar betweenStartDate = this.cloneAndSetTimeToStartOfDay(this.startDate);
                Calendar betweenEndDate = this.cloneAndSetTimeToEndOfDay(this.endDate);
                Constraint startConstraint = this.greaterThanOrEqualConstraint("startDate", betweenStartDate);
                Constraint endConstraint = this.lessThanOrEqualConstraint("startDate", betweenEndDate);
                constraints.add(startConstraint);
                constraints.add(endConstraint);
            }
        }
    }

    private Constraint equalConstraint(String propName, String value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.equal.to", this.vf.createValue(value));
    }

    private Constraint equalConstraint(String propName, long value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.equal.to", this.vf.createValue(value));
    }

    private Constraint greaterThanConstraint(String propName, long value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.greater.than", this.vf.createValue(value));
    }

    private Constraint greaterThanOrEqualConstraint(String propName, Calendar value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.greater.than.or.equal.to", this.vf.createValue(value));
    }

    private Constraint lessThanOrEqualConstraint(String propName, Calendar value) throws RepositoryException {
        return this.addConstraint(propName, "jcr.operator.less.than.or.equal.to", this.vf.createValue(value));
    }

    private Constraint addConstraint(String propName, String op, Value v) throws RepositoryException {
        return this.qf.comparison((DynamicOperand)this.qf.propertyValue(TASK_SELECTOR_NAME, propName), op, (StaticOperand)this.qf.literal(v));
    }

    private Constraint createSingleAndConstraint(List<Constraint> constraints) throws RepositoryException {
        Constraint andConstraint = constraints.get(0);
        for (int i = 1; i < constraints.size(); ++i) {
            andConstraint = this.qf.and(andConstraint, constraints.get(i));
        }
        return andConstraint;
    }

    private Calendar cloneAndSetTimeToStartOfDay(Calendar date) {
        Calendar startOfDay = (Calendar)date.clone();
        startOfDay.set(11, 0);
        startOfDay.set(12, 0);
        startOfDay.set(13, 0);
        startOfDay.set(14, 0);
        return startOfDay;
    }

    private Calendar cloneAndSetTimeToEndOfDay(Calendar date) {
        Calendar endOfDay = (Calendar)date.clone();
        endOfDay.set(11, 23);
        endOfDay.set(12, 59);
        endOfDay.set(13, 59);
        endOfDay.set(14, 999);
        return endOfDay;
    }
}

