/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;

public class InitialDeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;

    public InitialDeploymentTask(DeltaSpecification specification, List<? extends DeploymentStep> steps, RepositoryService repositoryService, WorkDir workDir) {
        super(steps, repositoryService, workDir);
        this.specification = specification;
        this.initFromDeployment(specification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        Authentication owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                InitialDeploymentTask.this.repositoryService.checkReferentialIntegrity(InitialDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        DeployedApplication newDeployment = this.specification.getDeployedApplication();
        ArrayList roes = Lists.newArrayList();
        for (Delta operation : this.specification.getDeltas()) {
            Deployed deployed = operation.getDeployed();
            roes.add(deployed);
            newDeployment.addDeployed(deployed);
        }
        roes.add(newDeployment);
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateCis(roes);
        return changeset;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        Authentication owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                InitialDeploymentTask.this.repositoryService.execute(InitialDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.INITIAL;
    }
}

