package com.xebialabs.deployit.task;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive.TaskCallback;

public interface TaskArchive {

	/**
	 * Archives a deployment task to the task archive persistent store.
	 * 
	 * @param task
	 *            is the deployment task to archive.
	 */
	void archiveTask(final DeploymentTask task);

	/**
	 * Retrieve a from the persistent store, using the taskId
	 * 
	 * @param taskId
	 *            can be a fully qualified path to the task, or the tasks uuid.
	 * @return DeploymentTaskInfo which is never null
	 * @throws com.xebialabs.deployit.exception.NotFoundException
	 *             when task is not found.
	 */
	DeploymentTaskInfo getTask(final String taskId);

	/**
	 * Searches the persistent store for archived tasks.
	 * 
	 * @param archivedTaskSearchParameters
	 *            to use to build the search query.
	 * @return results of search. Never null.
	 */
	Collection<DeploymentTaskInfo> searchTasks(ArchivedTaskSearchParameters archivedTaskSearchParameters);
	
	/**
	 * Searches the persistent store for archived tasks.It doesn't load steps of tasks.
	 * 
	 * @param archivedTaskSearchParameters
	 *            to use to build the search query.
	 * @return results of search. Never null.
	 */
	Collection<DeploymentTaskInfo> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters archivedTaskSearchParameters);

	/**
	 * Searches the persistent store for archived tasks and executes the callback method on the result.
	 * 
	 * @param archivedTaskSearchParameters
	 *            to use to build the search query.
	 * @param callback
	 *            Callback method.
	 */
	void searchTasks(ArchivedTaskSearchParameters archivedTaskSearchParameters, TaskCallback callback);

	/**
	 * Searches the persistent store for archived tasks and executes the callback method on the result. It doesn't load steps of tasks.
	 * 
	 * @param archivedTaskSearchParameters
	 *            to use to build the search query.
	 * @param callback
	 *            Callback method.
	 */
	void searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters archivedTaskSearchParameters, TaskCallback callback);

	/**
	 * Searches the persistent store for archived tasks and groups by given parameters. It doesn't load steps of tasks.
	 * 
	 * @param sp
	 * @param groupBy
	 * @return
	 */
	Collection<Map<String, Object>> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters sp, GroupBy groupBy);

	/**
	 * Searches the persistent store for archived tasks Id's.
	 * 
	 * @return results list of all task Id's. List might be empty.
	 */
	List<String> getAllTaskIds();

    /**
     * Searches the persistent store for all the environments that are known to have tasks.
     * @return results list of environments.
     */
    List<String> getAllEnvironments();
}