package com.xebialabs.deployit.jcr;

import org.apache.jackrabbit.value.*;

import javax.jcr.*;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class JcrUtils {
	
	public static Map<String, String> readMap(Property property) throws RepositoryException {
		Map<String, String> map = newHashMap();
		checkState(property.isMultiple(), "The property [%s] should be multi-valued in order to read a Map<String, String>", property.getName());
		for (Value value : property.getValues()) {
			String string = value.getString();
			int i = string.indexOf("=");
			String k = string;
			String v = "";
			if (i > -1) {
				k = string.substring(0, i);
				v = string.substring(i + 1);
			}
			map.put(k, v);
		}
		return map;
	}

	public static void writeMap(Node node, String propertyName, Map<String, String> map) throws RepositoryException {
		List<Value> values = newArrayList();
		for (Map.Entry<String, String> entry : map.entrySet()) {
			values.add(new StringValue(entry.getKey() + "=" + entry.getValue()));
		}
		node.setProperty(propertyName, values.toArray(new Value[values.size()]));
	}

	public static void forEachNonJcrProperty(Node node, Callback<Property> f) throws RepositoryException {
		PropertyIterator properties = node.getProperties();
		while(properties.hasNext()) {
			Property p = properties.nextProperty();
			
			if (p.getName().startsWith("jcr:") || p.getName().startsWith(JcrConstants.METADATA_PROPERTY_NAME_PREFIX)) continue;
			f.apply(p);
		}
	}

	public static void clearProperties(Node node) throws RepositoryException {
		forEachNonJcrProperty(node, new JcrUtils.Callback<Property>() {
			public void apply(Property input) throws RepositoryException {
				input.remove();
			}
		});
	}


	public interface Callback<T> {
		public void apply(T input) throws RepositoryException;
	}
}
