/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.jcrarchive;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;

public class JcrArchivedTaskSearchQueryBuilder
extends ArchivedTaskSearchParameters {
    private ValueFactory vf;
    private QueryObjectModelFactory qf;
    static final String TASK_SELECTOR_NAME = "task";

    public JcrArchivedTaskSearchQueryBuilder(QueryManager queryManager, ValueFactory valueFactory, ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        super(archivedTaskSearchParameters);
        this.vf = valueFactory;
        this.qf = queryManager.getQOMFactory();
    }

    public QueryObjectModel buildQuery() throws RepositoryException {
        ArrayList arrayList = Lists.newArrayList();
        this.appendTaskUuidCriteria(arrayList);
        this.appendEnvironmentApplicationAndVersionCriteria(arrayList);
        this.appendExecutedByCriteria(arrayList);
        this.appendStatusCriteria(arrayList);
        this.appendDateRangeCriteria(arrayList);
        Selector selector = this.qf.selector("deployit:task", TASK_SELECTOR_NAME);
        return this.qf.createQuery((Source)selector, this.createSingleAndConstraint(arrayList), null, null);
    }

    private void appendTaskUuidCriteria(List<Constraint> list) throws RepositoryException {
        if (this.isNotBlank(this.taskUuid)) {
            list.add(this.equalConstraint("$id", this.taskUuid));
        }
    }

    private boolean isNotBlank(String string) {
        return !Strings.nullToEmpty((String)string).trim().isEmpty();
    }

    private void appendEnvironmentApplicationAndVersionCriteria(List<Constraint> list) throws RepositoryException {
        StringBuilder stringBuilder = new StringBuilder("/tasks");
        boolean bl = false;
        boolean bl2 = false;
        if (this.isNotBlank(this.environment)) {
            stringBuilder.append("/").append(this.environment);
            if (this.isNotBlank(this.application)) {
                bl = true;
                stringBuilder.append("/").append(this.application);
                if (this.isNotBlank(this.version)) {
                    bl2 = true;
                    stringBuilder.append("/").append(this.version);
                }
            }
        }
        if (!bl && this.isNotBlank(this.application)) {
            list.add(this.equalConstraint("application", this.application));
        }
        if (!bl2 && this.isNotBlank(this.version)) {
            list.add(this.equalConstraint("version", this.version));
        }
        list.add((Constraint)this.qf.descendantNode(TASK_SELECTOR_NAME, stringBuilder.toString()));
    }

    private void appendExecutedByCriteria(List<Constraint> list) throws RepositoryException {
        if (this.isNotBlank(this.executedBy)) {
            list.add(this.equalConstraint("ownerUser", this.executedBy));
        }
    }

    private void appendStatusCriteria(List<Constraint> list) throws RepositoryException {
        switch (this.status) {
            case COMPLETED: {
                list.add((Constraint)this.qf.and(this.equalConstraint("state", Task.State.DONE.name()), this.equalConstraint("failureCount", 0L)));
                break;
            }
            case CANCELLED: {
                list.add(this.equalConstraint("state", Task.State.CANCELLED.name()));
                break;
            }
            case COMPLETED_AFTER_RETRY: {
                Constraint constraint = this.equalConstraint("state", Task.State.DONE.name());
                Constraint constraint2 = this.greaterThanConstraint("failureCount", 0L);
                list.add((Constraint)this.qf.and(constraint, constraint2));
            }
        }
    }

    private void appendDateRangeCriteria(List<Constraint> list) throws RepositoryException {
        switch (this.dateRangeSearch) {
            case AFTER: {
                Calendar calendar = this.cloneAndSetTimeToStartOfDay(this.startDate);
                list.add(this.greaterThanOrEqualConstraint("startDate", calendar));
                break;
            }
            case BEFORE: {
                Calendar calendar = this.cloneAndSetTimeToEndOfDay(this.endDate);
                list.add(this.lessThanOrEqualConstraint("startDate", calendar));
                break;
            }
            case BETWEEN: {
                Calendar calendar = this.cloneAndSetTimeToStartOfDay(this.startDate);
                Calendar calendar2 = this.cloneAndSetTimeToEndOfDay(this.endDate);
                Constraint constraint = this.greaterThanOrEqualConstraint("startDate", calendar);
                Constraint constraint2 = this.lessThanOrEqualConstraint("startDate", calendar2);
                list.add(constraint);
                list.add(constraint2);
            }
        }
    }

    private Constraint equalConstraint(String string, String string2) throws RepositoryException {
        return this.addConstraint(string, "jcr.operator.equal.to", this.vf.createValue(string2));
    }

    private Constraint equalConstraint(String string, long l) throws RepositoryException {
        return this.addConstraint(string, "jcr.operator.equal.to", this.vf.createValue(l));
    }

    private Constraint greaterThanConstraint(String string, long l) throws RepositoryException {
        return this.addConstraint(string, "jcr.operator.greater.than", this.vf.createValue(l));
    }

    private Constraint greaterThanOrEqualConstraint(String string, Calendar calendar) throws RepositoryException {
        return this.addConstraint(string, "jcr.operator.greater.than.or.equal.to", this.vf.createValue(calendar));
    }

    private Constraint lessThanOrEqualConstraint(String string, Calendar calendar) throws RepositoryException {
        return this.addConstraint(string, "jcr.operator.less.than.or.equal.to", this.vf.createValue(calendar));
    }

    private Constraint addConstraint(String string, String string2, Value value) throws RepositoryException {
        return this.qf.comparison((DynamicOperand)this.qf.propertyValue(TASK_SELECTOR_NAME, string), string2, (StaticOperand)this.qf.literal(value));
    }

    private Constraint createSingleAndConstraint(List<Constraint> list) throws RepositoryException {
        Constraint constraint = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            constraint = this.qf.and(constraint, list.get(i));
        }
        return constraint;
    }

    private Calendar cloneAndSetTimeToStartOfDay(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return calendar2;
    }

    private Calendar cloneAndSetTimeToEndOfDay(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        return calendar2;
    }
}

