/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;

public class UndeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;
    private DeployedApplication existingDeployment;

    public UndeploymentTask(DeltaSpecification deltaSpecification, DeployedApplication deployedApplication, List<? extends DeploymentStep> list, RepositoryService repositoryService, WorkDir workDir) {
        super(list, repositoryService, workDir);
        this.specification = deltaSpecification;
        this.existingDeployment = deployedApplication;
        this.initFromDeployment(deployedApplication);
    }

    @Override
    public void performPreFlightChecks() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                ChangeSet changeSet = UndeploymentTask.this.determineRepositoryChanges();
                UndeploymentTask.this.repositoryService.checkReferentialIntegrity(changeSet);
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(this.existingDeployment.getId());
        for (Delta delta : this.specification.getDeltas()) {
            arrayList.add(delta.getPrevious().getId());
        }
        ChangeSet changeSet = new ChangeSet();
        changeSet.setDeleteCiIds(arrayList);
        return changeSet;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                ChangeSet changeSet = UndeploymentTask.this.determineRepositoryChanges();
                UndeploymentTask.this.repositoryService.execute(changeSet);
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.UNDEPLOY;
    }
}

