/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContextAttributes {
    private Map<String, Object> attributes;
    private Logger logger = LoggerFactory.getLogger(ExecutionContextAttributes.class);

    public ExecutionContextAttributes() {
        this.attributes = Maps.newHashMap();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void destroy() {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (!(entry.getValue() instanceof ExecutionContextListener)) continue;
            try {
                this.logger.debug("Invoking StepExecutionContextListener on context attribute " + entry.getKey());
                ((ExecutionContextListener)entry.getValue()).contextDestroyed();
            }
            catch (Exception exception) {
                this.logger.error("Could not destroy context attribute " + entry.getKey(), (Throwable)exception);
            }
        }
        this.attributes.clear();
    }
}

