/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.service.importer.ImporterException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;

public class ManifestReader {
    public static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    public static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.3";
    public static final String APPLICATION_ATTRIBUTE_NAME = "CI-Application";
    public static final String VERSION_ATTRIBUTE_NAME = "CI-Version";

    public static Manifest readManifest(TFile tFile) {
        Manifest manifest;
        TFileInputStream tFileInputStream = null;
        try {
            tFileInputStream = new TFileInputStream((File)tFile);
            manifest = new Manifest((InputStream)tFileInputStream);
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeIOException("Cannot read manifest file " + tFile, iOException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(tFileInputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)tFileInputStream);
        return manifest;
    }

    public static String getApplicationName(Manifest manifest) {
        return ManifestReader.getMainEntryAttribute(manifest, APPLICATION_ATTRIBUTE_NAME);
    }

    public static String getApplicationVersion(Manifest manifest) {
        return ManifestReader.getMainEntryAttribute(manifest, VERSION_ATTRIBUTE_NAME);
    }

    private static String getMainEntryAttribute(Manifest manifest, String string) {
        String string2 = manifest.getMainAttributes().getValue(string);
        if (string2 == null || string2.trim().isEmpty()) {
            throw new ImporterException("Deployment package does not declare the " + string + " main attribute", new Object[0]);
        }
        return string2;
    }

    public static void verifyPackageFormatVersion(Manifest manifest) {
        String string = ManifestReader.getMainEntryAttribute(manifest, PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME);
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(string)) {
            throw new ImporterException("Deployment package does not have the right Deployit-Package-Format-Version header value (actual: " + string + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")", new Object[0]);
        }
    }
}

