/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.PackageScanner;
import com.xebialabs.deployit.service.importer.reader.DeployableConfigurationItemReader;
import com.xebialabs.deployit.service.importer.reader.ManifestReader;
import com.xebialabs.deployit.util.GuavaFiles;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestBasedDarImporter
implements ListableImporter {
    public static final String TEMPORARY_FILES = "temporaryFiles";
    private static final Logger logger = LoggerFactory.getLogger(ManifestBasedDarImporter.class);

    public List<String> list(File file) {
        ArrayList arrayList = Lists.newArrayList(PackageScanner.scan(file));
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean canHandle(ImportSource importSource) {
        File file = importSource.getFile();
        return PackageScanner.isDarPackage(file) || PackageScanner.isExplodedPackage(file);
    }

    public PackageInfo preparePackage(ImportSource importSource, ImportingContext importingContext) {
        PackageInfo packageInfo = new PackageInfo(importSource);
        this.updatePackageInfoWithManifestValues(packageInfo);
        importingContext.setAttribute(TEMPORARY_FILES, (Object)Lists.newArrayList());
        return packageInfo;
    }

    private void updatePackageInfoWithManifestValues(PackageInfo packageInfo) {
        Manifest manifest = this.getManifest(packageInfo);
        ManifestReader.verifyPackageFormatVersion(manifest);
        packageInfo.setApplicationName(ManifestReader.getApplicationName(manifest));
        packageInfo.setApplicationVersion(ManifestReader.getApplicationVersion(manifest));
    }

    public ImportedPackage importEntities(PackageInfo packageInfo, ImportingContext importingContext) {
        ImportedPackage importedPackage = new ImportedPackage(packageInfo);
        Manifest manifest = this.getManifest(packageInfo);
        this.createDeployableEntities(packageInfo, manifest.getEntries(), importedPackage, importingContext);
        return importedPackage;
    }

    private void createDeployableEntities(PackageInfo packageInfo, Map<String, Attributes> map, ImportedPackage importedPackage, ImportingContext importingContext) {
        DeployableConfigurationItemReader deployableConfigurationItemReader = new DeployableConfigurationItemReader(map);
        for (Map.Entry<String, Attributes> entry : map.entrySet()) {
            if (deployableConfigurationItemReader.isMiddlewareResource(entry)) {
                importedPackage.addDeployable(deployableConfigurationItemReader.readMiddlewareConfiguration(importedPackage.getDeploymentPackage(), entry));
                continue;
            }
            importedPackage.addDeployable((Deployable)deployableConfigurationItemReader.readArtifact(importedPackage.getDeploymentPackage(), packageInfo.getSource(), entry, importingContext));
        }
    }

    private Manifest getManifest(PackageInfo packageInfo) {
        TFile tFile = PackageScanner.getManifestFileFromImportSource(packageInfo.getSource());
        return ManifestReader.readManifest(tFile);
    }

    public void cleanUp(PackageInfo packageInfo, ImportingContext importingContext) {
        List list = (List)importingContext.getAttribute(TEMPORARY_FILES);
        for (TFile tFile : list) {
            logger.debug("Cleaning up temporary file {}", (Object)tFile);
            try {
                File file = tFile.getFile();
                if (file.isDirectory()) {
                    GuavaFiles.deleteRecursively(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.info("Couldn't delete file: {}", (Object)file);
            }
            catch (IOException iOException) {
                logger.error("Couldn't clean up file {}", (Object)tFile, (Object)iOException);
            }
        }
    }
}

