/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.authentication.RememberMe;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class BasicAuthWithRememberMeFilter
extends BasicAuthenticationFilter {
    public BasicAuthWithRememberMeFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException {
        String string = httpServletRequest.getHeader("Authorization");
        String[] stringArray = this.extractAndDecodeHeader(string, httpServletRequest);
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)authentication.getName(), (Object)stringArray[1], authentication.getAuthorities());
        usernamePasswordAuthenticationToken.setDetails(authentication.getDetails());
        if (httpServletRequest.getRequestURI().contains("logout")) {
            RememberMe.forget((Authentication)usernamePasswordAuthenticationToken);
        } else {
            RememberMe.remember((Authentication)usernamePasswordAuthenticationToken);
        }
    }

    private String[] extractAndDecodeHeader(String string, HttpServletRequest httpServletRequest) throws IOException {
        byte[] byArray;
        byte[] byArray2 = string.substring(6).getBytes("UTF-8");
        try {
            byArray = Base64.decode((byte[])byArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String string2 = new String(byArray, this.getCredentialsCharset(httpServletRequest));
        int n = string2.indexOf(":");
        if (n == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{string2.substring(0, n), string2.substring(n + 1)};
    }
}

