/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.repository.NodeWriter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JcrRepositoryService
implements RepositoryService {
    private JcrTemplate jcrTemplate;
    private static Logger logger = LoggerFactory.getLogger(JcrRepositoryService.class);

    @Autowired
    public JcrRepositoryService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public boolean exists(final String string) {
        logger.debug("Checking whether node {} exists.", (Object)string);
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(string));
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> T read(String string) {
        logger.debug("Reading node {}.", (Object)string);
        Preconditions.checkNotNull((Object)string, (Object)"id is null");
        return this._read(string, null);
    }

    @Override
    public <T extends ConfigurationItem> T read(String string, WorkDir workDir) {
        logger.debug("Reading node {} with workdir {}.", (Object)string, (Object)workDir);
        Preconditions.checkNotNull((Object)string, (Object)"id is null");
        return this._read(string, workDir);
    }

    private <T extends ConfigurationItem> T _read(final String string, final WorkDir workDir) {
        Preconditions.checkNotNull((Object)string, (Object)"id is null");
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
                    return NodeReader.read(session, node, workDir);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    throw new NotFoundException(pathNotFoundException, "Repository entity [%s] not found", string);
                }
            }
        }));
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... TArray) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setCreateCis(Lists.newArrayList((Object[])TArray));
        this.execute(changeSet);
    }

    @Override
    public <T extends ConfigurationItem> void move(T t, String string) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.addMoveCi(t, string);
        this.execute(changeSet);
    }

    @Override
    public void rename(String string, String string2) {
        Checks.checkArgument(string2.indexOf(47) == -1, "New name [%s] should not contain a /", string2);
        ChangeSet changeSet = new ChangeSet();
        changeSet.addRenameCi(string, string2);
        this.execute(changeSet);
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... TArray) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setUpdateCis(Lists.newArrayList((Object[])TArray));
        this.execute(changeSet);
    }

    @Override
    public void delete(String ... stringArray) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setDeleteCiIds(Lists.newArrayList((Object[])stringArray));
        this.checkReferentialIntegrity(changeSet);
        this.execute(changeSet);
    }

    @Override
    public void execute(ChangeSet changeSet) {
        this.jcrTemplate.execute(new ChangeSetExecutor(changeSet));
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeSet) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new ReferentialIntegrityChecker(changeSet));
    }

    @Override
    public List<ConfigurationItemData> list(SearchParameters searchParameters) {
        logger.debug("Listing node IDs with parameters {}.", (Object)searchParameters);
        Preconditions.checkNotNull((Object)searchParameters);
        List list = this.listEntities(searchParameters);
        return Lists.transform(list, (Function)new Function<ConfigurationItem, ConfigurationItemData>(){

            public ConfigurationItemData apply(ConfigurationItem configurationItem) {
                return new ConfigurationItemData(configurationItem.getId(), configurationItem.getType());
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(final SearchParameters searchParameters) {
        logger.debug("Listing nodes with parameters {}.", (Object)searchParameters);
        Preconditions.checkNotNull((Object)searchParameters, (Object)"parameters is null");
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                Query query = new SearchQueryBuilder(searchParameters).build(session);
                QueryResult queryResult = query.execute();
                return JcrRepositoryService.this.getOrderedEntities(searchParameters, session, queryResult);
            }
        });
    }

    private <T extends ConfigurationItem> List<T> getOrderedEntities(SearchParameters searchParameters, Session session, QueryResult queryResult) throws RepositoryException, IOException {
        ArrayList arrayList = Lists.newArrayList();
        RowIterator rowIterator = queryResult.getRows();
        while (rowIterator.hasNext()) {
            try {
                Node node = rowIterator.nextRow().getNode("ci");
                Object t = NodeReader.read(session, node, null);
                arrayList.add(t);
            }
            catch (RepositoryException repositoryException) {}
        }
        return arrayList;
    }

    @Override
    public <T extends ConfigurationItem> List<T> getVersionHistory(final String string) {
        logger.debug("Retrieving version history for node {}.", (Object)string);
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                ArrayList arrayList = Lists.newArrayList();
                VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(JcrPathHelper.getAbsolutePathFromId(string));
                VersionIterator versionIterator = versionHistory.getAllLinearVersions();
                while (versionIterator.hasNext()) {
                    Version version = versionIterator.nextVersion();
                    if (version.getName().equals("jcr:rootVersion")) continue;
                    Node node = version.getFrozenNode();
                    Object t = NodeReader.read(session, node, null);
                    t.setId(string);
                    arrayList.add(t);
                }
                return arrayList;
            }
        });
    }

    private static class PropertyRef {
        private String owningNode;
        private String property;
        private String uuidOfReferencedNode;

        PropertyRef(String string, String string2, String string3) {
            this.owningNode = string;
            this.property = string2;
            this.uuidOfReferencedNode = string3;
        }
    }

    private static class ReferentialIntegrityChecker
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ReferentialIntegrityChecker(ChangeSet changeSet) {
            Preconditions.checkNotNull((Object)changeSet);
            this.changeset = changeSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(session);
            Multimap<String, PropertyRef> multimap = this.findReferencesToDeletedNodes(session);
            ChangeSetExecutor changeSetExecutor = new ChangeSetExecutor(this.changeset);
            changeSetExecutor.execute(session, false);
            try {
                this.checkForRemainingReferencesToDeletedNodes(multimap, session);
            }
            finally {
                session.refresh(false);
            }
            return null;
        }

        private void checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(Session session) throws RepositoryException {
            for (ConfigurationItem configurationItem : this.changeset.getCreateCis()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(configurationItem.getId()))) continue;
                throw new ItemAlreadyExistsException("Repository entity %s already exists", configurationItem.getId());
            }
        }

        private Multimap<String, PropertyRef> findReferencesToDeletedNodes(Session session) throws RepositoryException {
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            for (String string : this.changeset.getDeleteCiIds()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(string))) continue;
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
                PropertyIterator propertyIterator = node.getReferences();
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.nextProperty();
                    Node node2 = property.getParent();
                    arrayListMultimap.put((Object)string, (Object)new PropertyRef(node2.getPath(), property.getName(), node.getIdentifier()));
                }
            }
            return arrayListMultimap;
        }

        private void checkForRemainingReferencesToDeletedNodes(Multimap<String, PropertyRef> multimap, Session session) throws RepositoryException {
            for (String string : multimap.keySet()) {
                for (PropertyRef propertyRef : multimap.get((Object)string)) {
                    Value[] valueArray;
                    Value[] valueArray2;
                    Node node;
                    if (!session.nodeExists(propertyRef.owningNode) || !(node = session.getNode(propertyRef.owningNode)).hasProperty(propertyRef.property)) continue;
                    Property property = node.getProperty(propertyRef.property);
                    if (property.isMultiple()) {
                        valueArray2 = property.getValues();
                    } else {
                        Value[] valueArray3 = new Value[1];
                        valueArray2 = valueArray3;
                        valueArray3[0] = property.getValue();
                    }
                    for (Value value : valueArray = valueArray2) {
                        if (!value.getString().equals(propertyRef.uuidOfReferencedNode)) continue;
                        throw new ItemInUseException("Repository entity %s is still referenced by %s", string, propertyRef.owningNode);
                    }
                }
            }
        }
    }

    private static class SortHierarchyComparator
    implements Comparator<ConfigurationItem> {
        private SortHierarchyComparator() {
        }

        @Override
        public int compare(ConfigurationItem configurationItem, ConfigurationItem configurationItem2) {
            int n = StringUtils.countOccurrencesOf((String)configurationItem.getId(), (String)"/");
            int n2 = StringUtils.countOccurrencesOf((String)configurationItem2.getId(), (String)"/");
            return n - n2;
        }
    }

    private static class ChangeSetExecutor
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ChangeSetExecutor(ChangeSet changeSet) {
            Preconditions.checkNotNull((Object)changeSet);
            this.changeset = changeSet;
        }

        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.execute(session, true);
            return null;
        }

        public void execute(Session session, boolean bl) throws RepositoryException {
            try {
                this.createEntities(this.changeset.getCreateCis(), session);
                this.updateEntities(this.changeset.getUpdateCis(), session);
                this.moveEntities(this.changeset.getMoveCis(), session);
                this.renameEntities(this.changeset.getRenameCis(), session);
                SortedMap<String, VersionHistory> sortedMap = this.deleteEntities(this.changeset.getDeleteCiIds(), session);
                if (bl) {
                    this.saveSession(session);
                    this.removeVersionHistories(sortedMap);
                }
            }
            catch (ReferentialIntegrityException referentialIntegrityException) {
                throw new ItemInUseException(referentialIntegrityException, "Cannot delete configuration items [%s] because one of the configuration items, or one of their children, is still being referenced", Joiner.on((char)',').join(this.changeset.getDeleteCiIds()));
            }
        }

        private void createEntities(List<ConfigurationItem> list, Session session) throws RepositoryException {
            if (!list.isEmpty()) {
                logger.trace("Creating nodes...");
            }
            this.verifyEntitiesMeetCreationPreconditions(list);
            Collections.sort(list, new SortHierarchyComparator());
            ArrayList arrayList = Lists.newArrayList();
            for (ConfigurationItem configurationItem : list) {
                Node node = this.createNode(configurationItem, session);
                NodeWriter nodeWriter = new NodeWriter(session, configurationItem, node);
                nodeWriter.writeBasics();
                arrayList.add(nodeWriter);
            }
            this.writeEntities(arrayList);
        }

        private Node createNode(ConfigurationItem configurationItem, Session session) throws RepositoryException {
            this.validateNodeStoredInCorrectPath(configurationItem.getId(), configurationItem.getType(), session);
            logger.debug("Creating node {}.", (Object)configurationItem.getId());
            Node node = session.getRootNode().addNode(configurationItem.getId());
            int n = node.getIndex();
            if (n != 1) {
                node.remove();
                throw new ItemAlreadyExistsException("Repository entity with ID [%s] already exists", configurationItem.getId());
            }
            this.setMixins(configurationItem, node);
            return node;
        }

        private void updateEntities(List<ConfigurationItem> list, Session session) throws RepositoryException {
            if (!list.isEmpty()) {
                logger.trace("Updating nodes...");
            }
            List<Node> list2 = this.retrieveAndCheckpointNodesToBeUpdated(list, session);
            for (int i = 0; i < list.size(); ++i) {
                this.updateNode(list.get(i), list2.get(i), session);
            }
        }

        private List<Node> retrieveAndCheckpointNodesToBeUpdated(List<ConfigurationItem> list, Session session) throws RepositoryException {
            ArrayList arrayList = Lists.newArrayList();
            for (ConfigurationItem configurationItem : list) {
                Preconditions.checkNotNull((Object)configurationItem, (Object)"entity is null");
                Preconditions.checkNotNull((Object)configurationItem.getId(), (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(configurationItem.getId()));
                    this.checkpoint(node, session);
                    arrayList.add(node);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    throw new NotFoundException("Repository entity [%s] not found", configurationItem.getId());
                }
            }
            return arrayList;
        }

        private void updateNode(ConfigurationItem configurationItem, Node node, Session session) throws RepositoryException {
            logger.debug("Updating node {}.", (Object)configurationItem.getId());
            new NodeWriter(session, configurationItem, node).write();
        }

        private void moveEntities(List<Tuple<ConfigurationItem, String>> list, Session session) throws RepositoryException {
            if (!list.isEmpty()) {
                logger.debug("Moving nodes...");
            }
            for (Tuple<ConfigurationItem, String> tuple : list) {
                ConfigurationItem configurationItem = tuple.getA();
                String string = tuple.getB();
                Checks.checkArgument(!configurationItem.getId().equals(string), "Cannot move ci [%s] to same location", string);
                if (!configurationItem.getType().equals((Object)Type.valueOf(Directory.class))) {
                    Checks.checkArgument(!DescriptorRegistry.getDescriptor((Type)configurationItem.getType()).getRoot().equals((Object)Metadata.ConfigurationItemRoot.NESTED), "Can only move 'rooted' cis [%s]", configurationItem.getType());
                }
                this.validateNodeStoredInCorrectPath(string, configurationItem.getType(), session);
                this.moveNode(JcrPathHelper.getAbsolutePathFromId(configurationItem.getId()), JcrPathHelper.getAbsolutePathFromId(string), session);
            }
        }

        private void renameEntities(List<Tuple<String, String>> list, Session session) throws RepositoryException {
            if (!list.isEmpty()) {
                logger.trace("Renaming nodes...");
            }
            for (Tuple<String, String> tuple : list) {
                String string = tuple.getA();
                String string2 = string.substring(0, string.lastIndexOf(47) + 1) + tuple.getB();
                this.moveNode(JcrPathHelper.getAbsolutePathFromId(string), JcrPathHelper.getAbsolutePathFromId(string2), session);
            }
        }

        private void moveNode(String string, String string2, Session session) throws RepositoryException {
            logger.debug("Moving/renaming node {} to {}", (Object)string, (Object)string2);
            Preconditions.checkState((!session.nodeExists(string2) ? 1 : 0) != 0, (String)"The destination id [%s] exists.", (Object[])new Object[]{string2});
            session.move(string, string2);
        }

        private SortedMap<String, VersionHistory> deleteEntities(List<String> list, Session session) throws RepositoryException {
            if (list.isEmpty()) {
                logger.trace("Deleting nodes...");
            }
            List<Node> list2 = this.retrieveNodesToBeDeleted(list, session);
            TreeMap treeMap = Maps.newTreeMap();
            for (Node node : list2) {
                this.checkpointAndRetrieveVersionHistories(node, session, treeMap);
            }
            for (Node node : list2) {
                this.deleteNode(node, session);
            }
            return treeMap;
        }

        private List<Node> retrieveNodesToBeDeleted(List<String> list, Session session) throws RepositoryException {
            ArrayList arrayList = Lists.newArrayList();
            for (String string : list) {
                Preconditions.checkNotNull((Object)string, (Object)"id is null");
                logger.trace("Retrieving node {} to delete it.", (Object)string);
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
                    arrayList.add(node);
                }
                catch (PathNotFoundException pathNotFoundException) {}
            }
            return arrayList;
        }

        private void checkpointAndRetrieveVersionHistories(Node node, Session session, SortedMap<String, VersionHistory> sortedMap) throws RepositoryException {
            this.checkpoint(node, session);
            String string = JcrPathHelper.getIdFromAbsolutePath(node.getPath());
            logger.trace("Retrieving version history for node {} to delete it.", (Object)string);
            VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
            sortedMap.put(string, versionHistory);
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node node2 = nodeIterator.nextNode();
                this.checkpointAndRetrieveVersionHistories(node2, session, sortedMap);
            }
        }

        private void deleteNode(Node node, Session session) throws RepositoryException {
            logger.debug("Deleting node {}.", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
            node.remove();
        }

        private void checkpoint(Node node, Session session) throws RepositoryException {
            logger.trace("Checkpointing node {}.", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkpoint(node.getPath());
        }

        private void saveSession(Session session) throws RepositoryException {
            logger.trace("Committing JCR session");
            session.save();
        }

        private void removeVersionHistories(SortedMap<String, VersionHistory> sortedMap) throws RepositoryException {
            logger.trace("Removing version histories that have become obsolete because their corresponding nodes or one of their ancestors was deleted.");
            for (Map.Entry<String, VersionHistory> entry : sortedMap.entrySet()) {
                this.removeVersionHistory(entry.getKey(), entry.getValue());
            }
        }

        private void removeVersionHistory(String string, VersionHistory versionHistory) throws RepositoryException {
            logger.debug("Removing version history for node {}.", (Object)string);
            VersionIterator versionIterator = versionHistory.getAllVersions();
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                if (version.getName().equals("jcr:rootVersion")) continue;
                logger.trace("Removing version {} from version history for node {}.", (Object)version.getName(), (Object)string);
                versionHistory.removeVersion(version.getName());
            }
        }

        private void verifyEntitiesMeetCreationPreconditions(List<ConfigurationItem> list) {
            for (int i = 0; i < list.size(); ++i) {
                ConfigurationItem configurationItem = list.get(i);
                Preconditions.checkNotNull((Object)configurationItem, (String)"ci at index %s is null.", (Object[])new Object[]{i});
                Preconditions.checkNotNull((Object)configurationItem.getId(), (String)"ci at index %s has null id.", (Object[])new Object[]{i});
                if (!(configurationItem instanceof SourceArtifact)) continue;
                Checks.checkArgument(((SourceArtifact)configurationItem).getFile() != null, "Artifact %s should have file", configurationItem.getId());
            }
        }

        private void validateNodeStoredInCorrectPath(String string, Type type, Session session) throws RepositoryException {
            Checks.checkArgument(DescriptorRegistry.exists((Type)type), "Unknown configuration item type %s", type);
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
            String[] stringArray = string.split("/");
            if (descriptor.isAssignableTo(Directory.class)) {
                Checks.checkArgument(stringArray.length >= 2, "A core.Directory must be stored under a Root node, not under %s.", string);
                for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                    if (!configurationItemRoot.getRootNodeName().equals(stringArray[0])) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("A core.Directory must be stured under a valid Root node, not under %s.", string);
            }
            if (descriptor.getRoot() == Metadata.ConfigurationItemRoot.NESTED) {
                Checks.checkArgument(stringArray.length >= 3, "Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", type, string);
                String string2 = string.substring(0, string.lastIndexOf(47));
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(string2));
                Checks.checkArgument(node != null, "Configuration item of type %s cannot be stored at %s. The parent does not exist", type, string);
                Checks.checkArgument(node.isNodeType("deployit:configurationItem"), "Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", type, string);
                String string3 = node.getProperty("$configuration.item.type").getString();
                Descriptor descriptor2 = DescriptorRegistry.getDescriptor((String)string3);
                for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                    if (propertyDescriptor.getKind() != PropertyKind.CI || !propertyDescriptor.isAsContainment() || !descriptor2.isAssignableTo(propertyDescriptor.getReferencedType())) continue;
                    return;
                }
                for (PropertyDescriptor propertyDescriptor : descriptor2.getPropertyDescriptors()) {
                    if (propertyDescriptor.getKind() != PropertyKind.SET_OF_CI || !propertyDescriptor.isAsContainment() || !descriptor.isAssignableTo(propertyDescriptor.getReferencedType())) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", type, string);
            }
            Checks.checkArgument(stringArray[0].equals(descriptor.getRoot().getRootNodeName()), "Configuration item of type %s cannot be stored at %s. It should be stored under %s", type, string, descriptor.getRoot().getRootNodeName());
        }

        private void setMixins(ConfigurationItem configurationItem, Node node) throws RepositoryException {
            if (configurationItem instanceof Artifact) {
                node.addMixin("deployit:artifact");
                node.addMixin("deployit:configurationItem");
            } else {
                node.addMixin("deployit:configurationItem");
            }
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }

        private void writeEntities(List<NodeWriter> list) throws RepositoryException {
            for (NodeWriter nodeWriter : list) {
                nodeWriter.write();
            }
        }
    }
}

