package com.xebialabs.deployit.util;

/**
 * Poor man Scala...
 */
public abstract class Option<T> {
	private static final Option<?> NONE = new None();
	
	
	public abstract boolean isSet();
	
	public abstract T get();
	
	public static <T> Option<T> some(T value) {
		return new Some<T>(value);
	}
	
	public static <T> Option<T> none() {
		return (Option<T>) NONE;
	}
	
	public static class Some<T> extends Option<T> {
		private T value;

		public Some(T value) {
			this.value = value;
		}

		@Override
		public boolean isSet() {
			return true;
		}

		@Override
		public T get() {
			return value;
		}
	}
	
	public static class None<T> extends Option<T> {

		@Override
		public boolean isSet() {
			return false;
		}

		@Override
		public T get() {
			throw new IllegalArgumentException("None is not set");
		}
	}
}
