package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.server.api.repository.RawRepository;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class RawRepositoryImpl implements RawRepository {
	
	private Session session;

	public static final String QUERY_PREFIX = "SELECT CI.* FROM [" + JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME + "] AS ci WHERE";
	
	public RawRepositoryImpl(Session session) {
		this.session = session;
	}

	@Override
	public void renameType(String oldTypeName, String newTypeName) {
		for (Node node : findNodesByType(Type.valueOf(oldTypeName))) {
			try {
				node.setProperty(JcrConstants.CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, newTypeName);
			} catch (RepositoryException e) {
				throw new RuntimeRepositoryException(e);
			}
		}
	}

	@Override
	public Node read(String nodeId) {
		try {
			return session.getNode(nodeId);
		} catch (RepositoryException e) {
			throw new RuntimeRepositoryException(e);
		}
	}

	@Override
	public Node create(String nodeId) {
		try {
			return session.getRootNode().addNode(JcrPathHelper.getIdFromAbsolutePath(nodeId));
		} catch (RepositoryException e) {
			throw new RuntimeRepositoryException(e);
		}
	}

	@Override
	public void delete(String nodeId) {
		try {
			session.removeItem(nodeId);
		} catch (RepositoryException e) {
			throw new RuntimeRepositoryException(e);
		}
	}

	@Override
	public List<Node> findNodesByType(Type type) {
		List<Node> nodeList = newArrayList();
		try {
			QueryManager queryManager = session.getWorkspace().getQueryManager();
			Query query = queryManager.createQuery(QUERY_PREFIX + " ci.[" + JcrConstants.CONFIGURATION_ITEM_TYPE_PROPERTY_NAME + "] = '" + type.toString() + "'", Query.JCR_SQL2);
			QueryResult execute = query.execute();
			NodeIterator nodes = execute.getNodes();
			while (nodes.hasNext()) {
				nodeList.add(nodes.nextNode());
			}
		} catch (RepositoryException re) {
			throw new RuntimeRepositoryException(re);
		}
		
		return nodeList;	
	}

	public Session getSession() {
		return session;
	}

	public static class RuntimeRepositoryException extends RuntimeException {
		public RuntimeRepositoryException(Throwable cause) {
			super(cause);
		}
	}
}
