package com.xebialabs.deployit.task;

import java.util.Collection;
import java.util.List;

/**
 */
public interface TaskRegistry {

	String registerTask(Task task);

	Task getTask(String id);
	
	void cancelTask(String id);

	/**
	 * Returns all incomplete tasks for the given username.
	 */
	List<Task> getIncompleteTasksForUser(String username);

	/**
	 * Returns ALL incomplete tasks for any user.
	 */
	List<Task> getAllIncompleteTasks();

    Collection<Task> getTasks();
    
    TaskArchive getTaskArchive();

    void destroy();

    /**
     * Assigns the given task to the specified owner. Current user 
     * is assumed to be allowed to perform the assignment, no
     * further checks are made.
     */
	void assignTask(String taskId, String owner);

    /**
     * Assigns the given task to the specified owner. Checks wether
     * the current user is also the current owner of the task.
     */
	void assignMyTask(String taskId, String owner);
}
