package com.xebialabs.deployit.task;

import java.util.Calendar;
import java.util.List;

/*
 * FIXME: Rename to ArchivedTask
 */
public class DeploymentTaskInfo {

	private String id;

	private String owner;

	private Calendar startDate;

	private Calendar completionDate;

	private List<TaskStepInfo> steps;

	private Task.State state;

	private DeploymentTask.DeploymentType deploymentType;

	private String applicationName;

	private String applicationVersion;

	private String environment;

	private int currentStepNr;

	private int failureCount;

	public TaskStepInfo getStep(int stepNr) {
		if (stepNr < 1 || stepNr > steps.size()) {
			throw new IllegalArgumentException(stepNr + " is not a valid step number");
		}
		return steps.get(stepNr - 1);
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public Calendar getStartDate() {
		return startDate;
	}

	public void setStartDate(Calendar startDate) {
		this.startDate = startDate;
	}

	public Calendar getCompletionDate() {
		return completionDate;
	}

	public long getDurationInMillis() {
		return completionDate.getTimeInMillis() - startDate.getTimeInMillis();
	}

    public List<TaskStepInfo> getSteps() {
        return steps;
    }

    public void setCompletionDate(Calendar completionDate) {
		this.completionDate = completionDate;
	}

	public void setSteps(List<TaskStepInfo> steps) {
		this.steps = steps;
	}

	public Task.State getState() {
		return state;
	}

	public void setState(Task.State state) {
		this.state = state;
	}

	public String getApplicationName() {
		return applicationName;
	}

	public void setApplicationName(String applicationName) {
		this.applicationName = applicationName;
	}

	public String getApplicationVersion() {
		return applicationVersion;
	}

	public void setApplicationVersion(String applicationVersion) {
		this.applicationVersion = applicationVersion;
	}

	public String getEnvironment() {
		return environment;
	}

	public void setEnvironment(String environment) {
		this.environment = environment;
	}

	public int getFailureCount() {
		return failureCount;
	}

	public void setFailureCount(int failureCount) {
		this.failureCount = failureCount;
	}

	public int getCurrentStepNr() {
		return currentStepNr;
	}

	public void setCurrentStepNr(int currentStepNr) {
		this.currentStepNr = currentStepNr;
	}

	public DeploymentTask.DeploymentType getDeploymentType() {
		return deploymentType;
	}

	public void setDeploymentType(DeploymentTask.DeploymentType deploymentType) {
		this.deploymentType = deploymentType;
	}

	@Override
	public String toString() {
		return "DeploymentTaskInfo{" + "id='" + id + '\'' + ", owner='" + owner + '\'' + ", startDate=" + startDate + ", completionDate=" + completionDate
		        + ", steps=" + steps + ", state=" + state + ", deploymentType=" + deploymentType + ", applicationName='" + applicationName + '\''
		        + ", applicationVersion='" + applicationVersion + '\'' + ", environment='" + environment + '\'' + ", currentStepNr=" + currentStepNr + '}';
	}
}
