package com.xebialabs.deployit.service.gc;

import java.util.concurrent.atomic.AtomicBoolean;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;

import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;

@SuppressWarnings({ "rawtypes", "serial" })
public class GarbageCollectionStep implements Step<ExecutionContext> {

	private Repository repository;
	private AtomicBoolean gcInProgress;
	
	public GarbageCollectionStep(Repository repository, AtomicBoolean gcInProgress) {
		this.repository = repository;
		this.gcInProgress = gcInProgress;
	}
	@Override
	public String getDescription() {
		return "Running garbage collection on the repository";
	}

	@Override
	public com.xebialabs.deployit.plugin.api.execution.Step.Result execute(ExecutionContext ctx)
			throws Exception {
		logger.info("Running garbage collector to compact the DataStore");
		gcInProgress.set(true);
		
		try {
			Session garbageCollectionSession = repository.login(new SimpleCredentials(JcrConstants.ANONYMOUS_USERNAME, "".toCharArray()));;
			try {
				// Note: casting the repository here to RepositoryImpl to get at the garbage collector.
				// The repository is created in the JackrabbitRepositoryFactoryBean as a RepositoryImpl instance.
				DataStoreGarbageCollector gc = ((RepositoryImpl) repository).createDataStoreGarbageCollector();
				try {
					gc.mark();
					gc.sweep();
				} finally {
					gc.close();
				}
		
			} finally {
				garbageCollectionSession.logout();
			}
		
			logger.info("Garbage collector completed");
		} catch (RepositoryException exc) {
			logger.error("Cannot run the gargage collector", exc);
		}
		
		// Task is non-interactive, so always returning success.
		return Result.Success;
	}

	private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionStep.class);
}
