package com.xebialabs.deployit.repository;

import com.google.common.util.concurrent.Monitor;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

@Component
public class WorkDirFactory {

	@Autowired
	private String baseWorkDirPath;

	private File baseWorkDir;
	
	private static final Monitor M = new Monitor(); 

	public WorkDirFactory() {
	}

	@PostConstruct
	public void postConstruct() {
		baseWorkDir = new File(baseWorkDirPath);
		if (!baseWorkDir.mkdirs() && !baseWorkDir.exists()) {
			throw new RuntimeIOException("Couldn't create the base work directory: " + baseWorkDirPath);
		}
	}

	public WorkDirFactory(String baseWorkDirPath) {
		this.baseWorkDirPath = baseWorkDirPath;
	}

	public WorkDir newWorkDir() {
		OverthereFile temporaryDirectory = LocalFile.valueOf(baseWorkDir);
		AtomicInteger integer = new AtomicInteger(1);
		DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
		String prefix = "workdir-" + dateFormat.format(new Date());
		String infix = "";
		String suffix = ".tmp";
		while(integer.get() < 100) {
			OverthereFile tempDir = temporaryDirectory.getFile(prefix + infix + suffix);
			M.enter();
			try {
				if(!tempDir.exists()) {
					try {
						tempDir.mkdir();
					} catch (RuntimeIOException ioe) {
						// Workdir exists... continue
					}
					logger.debug("Created WorkDir {}", tempDir);
					return new WorkDir((LocalFile) tempDir);
				}
			} finally {
				M.leave();
			}
			infix = "-" + integer.getAndIncrement();
		}
		throw new RuntimeIOException("Cannot create WorkDir " + prefix);
	}

	private static final Logger logger = LoggerFactory.getLogger(WorkDirFactory.class);

}
