package com.xebialabs.deployit.io;

import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;

@SuppressWarnings("serial")
public class FileWithoutContent implements OverthereFile, Serializable {

	private final String name;

	public FileWithoutContent(String name) {
		this.name = name;
	}

	@Override
	public OverthereConnection getConnection() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public String getPath() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public OverthereFile getParentFile() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public OverthereFile getFile(String child) {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public boolean canRead() {
		return false;
	}

	@Override
	public boolean canWrite() {
		return false;
	}

	@Override
	public boolean canExecute() {
		return false;
	}

	@Override
	public boolean isFile() {
		return false;
	}

	@Override
	public boolean isDirectory() {
		return false;
	}

	@Override
	public boolean isHidden() {
		return false;
	}

	@Override
	public long lastModified() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public long length() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public InputStream getInputStream() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public OutputStream getOutputStream() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void setExecutable(boolean executable) {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void delete() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void deleteRecursively() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public List<OverthereFile> listFiles() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void mkdir() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void mkdirs() {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void renameTo(OverthereFile dest) {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}

	@Override
	public void copyTo(OverthereFile dest) {
		throw new UnsupportedOperationException("Not used by FileWithoutContent");
	}
}
