package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.permission.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

import java.util.Collection;

public class LoginPermissionVoter implements AccessDecisionVoter<Object> {
	@Override
	public boolean supports(ConfigAttribute attribute) {
		return true;
	}

	@Override
	public boolean supports(Class<?> clazz) {
		return true;
	}

	@Override
	public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
		logger.debug("Checking authorization for [{}]", authentication.getName());
		if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, Permission.LOGIN)) {
			logger.debug("User [{}] is authorized for login", authentication.getName());
			return ACCESS_GRANTED;
		}
		logger.error("User [{}] is not allowed to login to Deployit.", authentication.getName());
		return ACCESS_DENIED;
	}
	
	private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);
}
