/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.grouping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupBy {
    private final List<Function<?>> functions;
    private final Map<String, Map<String, Object>> result = Maps.newHashMap();
    private final Set<String> propertyNames;
    private final Map<String, Field> fields;

    public GroupBy(Collection<String> collection, Function<?> ... functionArray) {
        this.fields = this.getFields(collection);
        this.propertyNames = Sets.newTreeSet(collection);
        this.functions = functionArray != null ? Lists.newArrayList((Object[])functionArray) : Lists.newArrayList();
    }

    private Map<String, Field> getFields(Collection<String> collection) {
        HashMap hashMap = Maps.newHashMap();
        for (String string : collection) {
            try {
                Field field = DeploymentTaskInfo.class.getDeclaredField(string);
                field.setAccessible(true);
                hashMap.put(string, field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                new IllegalArgumentException(String.format("Property is %s not defined in %s.", string, DeploymentTaskInfo.class.getName()), noSuchFieldException);
            }
        }
        return hashMap;
    }

    public void process(DeploymentTaskInfo deploymentTaskInfo) {
        String string = this.buildKey(deploymentTaskInfo);
        HashMap hashMap = this.result.get(string);
        if (hashMap == null) {
            hashMap = Maps.newHashMap();
            for (String string2 : this.propertyNames) {
                try {
                    hashMap.put(string2, this.fields.get(string2).get(deploymentTaskInfo));
                }
                catch (IllegalAccessException illegalAccessException) {
                    new IllegalArgumentException(String.format("Property is %s not defined in %s.", string2, DeploymentTaskInfo.class.getName()), illegalAccessException);
                }
            }
            this.result.put(string, hashMap);
        }
        this.executeFunctions(deploymentTaskInfo, string, hashMap);
    }

    private String buildKey(DeploymentTaskInfo deploymentTaskInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.propertyNames) {
            try {
                stringBuilder.append(this.fields.get(string).get(deploymentTaskInfo));
                stringBuilder.append("_");
            }
            catch (Exception exception) {
                new IllegalArgumentException(String.format("Property is %s not defined in %s.", string, DeploymentTaskInfo.class.getName()), exception);
            }
        }
        String string = stringBuilder.toString();
        return string;
    }

    private void executeFunctions(DeploymentTaskInfo deploymentTaskInfo, String string, Map<String, Object> map) {
        for (Function<?> function : this.functions) {
            map.put(function.getName(), function.invoke(map.get(function.getName()), deploymentTaskInfo));
        }
    }

    public Collection<Map<String, Object>> getResult() {
        return this.result.values();
    }
}

