/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.internal.Root;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Calendar;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class JackrabbitRepositoryFactoryBean
implements InitializingBean,
FactoryBean<Repository>,
DisposableBean {
    private Resource homeDir;
    private Resource configuration;
    private JackrabbitRepository repository;
    private boolean autoInitialize;
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitRepositoryFactoryBean.class);

    public void afterPropertiesSet() throws IOException, RepositoryException {
        logger.info("Starting JCR repository");
        InputSource inputSource = new InputSource(this.configuration.getInputStream());
        File file = this.homeDir.getFile();
        if (!file.exists() && !this.autoInitialize) {
            throw new RepositoryException("Jackrabbit home dir " + file + " does not exist. Please run the Deployit server with -setup -reinitialize to reinitialize the Deployit repository.");
        }
        RepositoryConfig repositoryConfig = RepositoryConfig.create((InputSource)inputSource, (String)file.getAbsolutePath());
        this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
        this.initializeJcrRepository();
        logger.debug("Started JCR repository");
    }

    private void initializeJcrRepository() {
        new JcrTemplate((Repository)this.repository).execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
                try {
                    namespaceRegistry.getURI("deployit");
                    return null;
                }
                catch (NamespaceException namespaceException) {
                    if (!JackrabbitRepositoryFactoryBean.this.autoInitialize) {
                        throw new RepositoryException("The Deployit repository has not been initialized. Please run the Deployit server with -setup -reinitialize to reinitialize the Deployit repository.");
                    }
                    logger.info("Initializing JCR repository");
                    namespaceRegistry.registerNamespace("deployit", "http://www.xebialabs.com/deployit");
                    NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
                    JackrabbitRepositoryFactoryBean.this.createMixinNodeType(nodeTypeManager, "deployit:configurationItem");
                    JackrabbitRepositoryFactoryBean.this.createMixinNodeType(nodeTypeManager, "deployit:artifact");
                    JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName());
                    JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.INFRASTRUCTURE.getRootNodeName());
                    JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName());
                    JackrabbitRepositoryFactoryBean.this.createMixinNodeType(nodeTypeManager, "deployit:task");
                    JackrabbitRepositoryFactoryBean.this.createMixinNodeType(nodeTypeManager, "deployit:step");
                    JackrabbitRepositoryFactoryBean.this.createNode(session, "tasks", new String[0]);
                    JackrabbitRepositoryFactoryBean.this.createMixinNodeType(nodeTypeManager, "deployit:configuration");
                    JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration", new String[]{"deployit:configuration"});
                    JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration/security", new String[0]);
                    JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration/roles", new String[0]);
                    JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration/roleAssignments", new String[0]);
                    JackrabbitRepositoryFactoryBean.this.setAccessControlOnRootNode(session);
                    JackrabbitRepositoryFactoryBean.this.setRepoVersion(session);
                    logger.debug("Initialized JCR repository");
                    return null;
                }
            }
        });
    }

    private void setRepoVersion(Session session) throws RepositoryException {
        Node node = session.getRootNode().addNode("$configuration/versions");
        node.setProperty("deployit", ReleaseInfo.getReleaseInfo().getVersion());
        session.save();
    }

    private void createMixinNodeType(NodeTypeManager nodeTypeManager, String string) throws RepositoryException {
        NodeTypeTemplate nodeTypeTemplate = nodeTypeManager.createNodeTypeTemplate();
        nodeTypeTemplate.setName(string);
        nodeTypeTemplate.setQueryable(true);
        nodeTypeTemplate.setAbstract(false);
        nodeTypeTemplate.setMixin(true);
        nodeTypeManager.registerNodeType((NodeTypeDefinition)nodeTypeTemplate, false);
    }

    private void createRoot(Session session, String string) throws RepositoryException {
        Node node = session.getRootNode().addNode(string);
        node.addMixin("deployit:configurationItem");
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        node.setProperty("$configuration.item.type", "internal." + Root.class.getSimpleName());
        node.setProperty("$lastModified", Calendar.getInstance());
        session.save();
    }

    private void createNode(Session session, String string, String ... stringArray) throws RepositoryException {
        Node node = session.getRootNode();
        Node node2 = node.addNode(string);
        for (String string2 : stringArray) {
            node2.addMixin(string2);
        }
        session.save();
    }

    protected void setAccessControlOnRootNode(Session session) throws RepositoryException {
        AccessControlManager accessControlManager = session.getAccessControlManager();
        AccessControlPolicyIterator accessControlPolicyIterator = accessControlManager.getApplicablePolicies("/");
        boolean bl = false;
        while (!bl && accessControlPolicyIterator.hasNext()) {
            AccessControlPolicy accessControlPolicy = accessControlPolicyIterator.nextAccessControlPolicy();
            if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList jackrabbitAccessControlList = (JackrabbitAccessControlList)accessControlPolicy;
            Privilege privilege = accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            EveryonePrincipal everyonePrincipal = EveryonePrincipal.getInstance();
            for (AccessControlEntry accessControlEntry : jackrabbitAccessControlList.getAccessControlEntries()) {
                if (!((Object)accessControlEntry.getPrincipal()).equals(everyonePrincipal)) continue;
                jackrabbitAccessControlList.removeAccessControlEntry(accessControlEntry);
            }
            jackrabbitAccessControlList.addEntry((Principal)everyonePrincipal, new Privilege[]{privilege}, true);
            logger.debug("Setting {} on root", (Object)jackrabbitAccessControlList);
            accessControlManager.setPolicy("/", (AccessControlPolicy)jackrabbitAccessControlList);
        }
    }

    public Repository getObject() {
        return this.repository;
    }

    public void destroy() {
        this.repository.shutdown();
    }

    public Class<Repository> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    @Required
    public void setHomeDir(Resource resource) {
        this.homeDir = resource;
    }

    public Resource getConfiguration() {
        return this.configuration;
    }

    @Required
    public void setConfiguration(Resource resource) {
        this.configuration = resource;
    }

    public boolean isAutoInitialize() {
        return this.autoInitialize;
    }

    public void setAutoInitialize(boolean bl) {
        this.autoInitialize = bl;
    }
}

