/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.checks;

import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;

public class Checks {
    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IncorrectArgumentException(string, objectArray);
        }
    }

    public static <T> T checkNotNull(T t, String string) {
        if (t == null) {
            throw new MissingArgumentException(string);
        }
        return t;
    }

    public static <T> T checkNotNull(T t, String string, Object ... objectArray) {
        if (t == null) {
            throw new MissingArgumentException(string, objectArray);
        }
        return t;
    }

    public static void checkTrue(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new ConditionFailedException(string, objectArray);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class IncorrectArgumentException
    extends DeployitException {
        public IncorrectArgumentException(String string, Object ... objectArray) {
            super(string, objectArray);
        }
    }

    @HttpResponseCodeResult
    public static class ConditionFailedException
    extends DeployitException {
        private ConditionFailedException(String string, Object ... objectArray) {
            super(string, objectArray);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class MissingArgumentException
    extends DeployitException {
        public MissingArgumentException(String string) {
            super("Parameter %s is missing", string);
        }

        public MissingArgumentException(String string, Object ... objectArray) {
            super(string, objectArray);
        }
    }
}

