package com.xebialabs.deployit.util;

import com.google.common.base.Preconditions;

import java.io.File;
import java.io.IOException;

public class GuavaFiles {

	public static void deleteDirectoryContents(File directory)
			throws IOException {
		Preconditions.checkArgument(directory.isDirectory(),
				"Not a directory: %s", directory);

		// JvE: This check does not work for temporary directories in MacOS...
		// Symbolic links will have different canonical and absolute paths
		//	  if (!directory.getCanonicalPath().equals(directory.getAbsolutePath())) {
		//	    return;
		//	  }

		File[] files = directory.listFiles();
		if (files == null) {
			throw new IOException("Error listing files for " + directory);
		}
		for (File file : files) {
			deleteRecursively(file);
		}
	}

	public static void deleteRecursively(File file) throws IOException {
		if (file.isDirectory()) {
			deleteDirectoryContents(file);
		}
		if (!file.delete()) {
			throw new IOException("Failed to delete " + file);
		}
	}

	public static void deleteQuietly(File file) {
		try {
			deleteRecursively(file);
		} catch (Exception e) {
			// Ignore
		}
	}
	
}
