package com.xebialabs.deployit.task.deployment;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import org.springframework.security.core.Authentication;

@SuppressWarnings("serial")
public class InitialDeploymentTask extends DeploymentTask {

    private DeltaSpecification specification;

	public InitialDeploymentTask(final DeltaSpecification specification, final List<? extends DeploymentStep> steps, final RepositoryService repositoryService, WorkDir workDir) {
		super(steps, repositoryService, workDir);
        this.specification = specification;
		initFromDeployment(specification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        Authentication owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner, new SecurityCallback<Object>() {
            @Override
            public Object doAs() {
                repositoryService.checkReferentialIntegrity(determineRepositoryChanges());
                return null;
            }
        });
    }

    @SuppressWarnings("rawtypes")
    private ChangeSet determineRepositoryChanges() {
        DeployedApplication newDeployment = specification.getDeployedApplication();
        List<ConfigurationItem> roes = newArrayList();
        for (Delta operation : specification.getDeltas()) {
            Deployed deployed = operation.getDeployed();
            roes.add(deployed);
            newDeployment.addDeployed(deployed);
        }

        roes.add(newDeployment);
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateCis(roes);
        return changeset;
    }

    @Override
	public void doAfterTaskStateChangedToDone() {
		Authentication owner = getOwnerCredentials();
		SecurityTemplate.executeAs(owner, new SecurityCallback<Object>() {
			@Override
			public Object doAs() {
                repositoryService.execute(determineRepositoryChanges());
				return null;
			}
		});
	}

    @Override
    public DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.INITIAL;
    }

}
