package com.xebialabs.deployit.service.gc;

import javax.jcr.Repository;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.xebialabs.deployit.task.ExecutionEngine;

public class GarbageCollectionServiceImpl implements GarbageCollectionService {

	private Repository repository;
	private ExecutionEngine executionEngine;

	@Autowired
	public GarbageCollectionServiceImpl(Repository repository, ExecutionEngine executionEngine) {
		this.repository = repository;
		this.executionEngine = executionEngine;
	}

	@Override
	public void runGarbageCollector() {
		if (GarbageCollectionTask.isInProgress()) {
			logger.warn("Not starting new garbage collector since garbage collection already in progress");
			return;
		}
		
		GarbageCollectionTask task = new GarbageCollectionTask(repository);
		String id = executionEngine.register(task);
		executionEngine.execute(id);
	}

	private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionServiceImpl.class);
}
