package com.xebialabs.deployit.repository;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;

public class JcrPathHelper {

	public static String getAbsolutePathFromId(final String id) {
		return "/" + id;
	}

	public static String getIdFromAbsolutePath(final String absPath) {
		return absPath.startsWith("/") ? absPath.substring(1) : absPath;
	}

	public static String toValidNodeName(String str) {
		return str.replace('/', '_');
	}

	public static String buildId(Metadata.ConfigurationItemRoot root, String... pathComponents) {
		return buildId(root.getRootNodeName(), pathComponents);
	}

	public static String buildId(String parentId, String... pathComponents) {
		StringBuilder b = new StringBuilder();
		b.append(parentId);
		for (String each : pathComponents) {
			b.append('/').append(each);
		}
		return b.toString();
	}

	public static String getParentId(String id) {
		int lastSlashPos = Strings.nullToEmpty(id).lastIndexOf('/');
		if (lastSlashPos > 0) {
			return id.substring(0, lastSlashPos);
		} else {
			return "";
		}
	}

}
