/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContextAttributes {
    private Map<String, Object> attributes;
    private Logger logger = LoggerFactory.getLogger(ExecutionContextAttributes.class);

    public ExecutionContextAttributes() {
        this.attributes = Maps.newHashMap();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void destroy() {
        for (Map.Entry<String, Object> each : this.attributes.entrySet()) {
            if (!(each.getValue() instanceof ExecutionContextListener)) continue;
            try {
                this.logger.debug("Invoking StepExecutionContextListener on context attribute " + each.getKey());
                ((ExecutionContextListener)each.getValue()).contextDestroyed();
            }
            catch (Exception exc) {
                this.logger.error("Could not destroy context attribute " + each.getKey(), (Throwable)exc);
            }
        }
        this.attributes.clear();
    }
}

