/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.task.StepList;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import java.util.ArrayList;
import java.util.List;

public abstract class DeploymentTask
extends Task {
    private ArrayList<WorkDir> workDirs = Lists.newArrayList();
    protected final transient RepositoryService repositoryService;
    private String applicationName;
    private String applicationVersion;
    private String environment;

    public DeploymentTask(List<? extends DeploymentStep> steps, RepositoryService repositoryService, WorkDir ... workDirs) {
        super(steps);
        this.repositoryService = repositoryService;
        if (workDirs != null) {
            this.workDirs = Lists.newArrayList((Object[])workDirs);
        }
    }

    protected DeploymentTask(List<TaskStep> steps, Task.State state) {
        this(new StepList(steps, steps.size()), state);
    }

    DeploymentTask(StepList stepList, Task.State state) {
        super(stepList, state);
        this.repositoryService = null;
    }

    @Override
    public void destroy() {
        for (WorkDir workDir : this.workDirs) {
            workDir.delete();
        }
        super.destroy();
    }

    protected void initFromDeployment(DeployedApplication deployment) {
        this.setApplicationName(deployment.getVersion().getApplication().getName());
        this.setApplicationVersion(deployment.getVersion().getVersion());
        this.setEnvironment(deployment.getEnvironment().getName());
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public abstract DeploymentType getDeploymentType();

    public static enum DeploymentType {
        INITIAL,
        UPGRADE,
        UNDEPLOY,
        UNKNOWN;

    }
}

