package com.xebialabs.deployit.service.controltask;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.controltask.ControlTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

@Component
public class ControlTaskService {

	private ExecutionEngine executionEngine;

	@Autowired
	public ControlTaskService(ExecutionEngine executionEngine) {
		this.executionEngine = executionEngine;
	}

	public ControlTask execute(ConfigurationItem ci, String controlTaskName) {
		MethodDescriptor controlTask = getControlTask(ci, controlTaskName);
		List<Step<?>> steps = controlTask.invoke(ci);
		ControlTask task = new ControlTask(steps);
		String id = executionEngine.register(task);
		executionEngine.execute(id);
		task.awaitFinish();
		return task;
	}

	private MethodDescriptor getControlTask(ConfigurationItem ci, String controlTaskName) {
		Type type = ci.getType();
		Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
		MethodDescriptor controlTask = descriptor.getControlTask(controlTaskName);
		checkArgument(controlTask != null, "ConfigurationItem %s of type %s does not have a control task named %s.", ci.getId(), ci.getType(), controlTaskName);
		return controlTask;
	}
}
