package com.xebialabs.deployit.security.permission;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;

import java.util.Collection;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class UpgradeDeploymentHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.DEPLOY_UPGRADE, user, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
		permission(Permission.DEPLOY_UPGRADE, user, onConfigurationItem, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
		final Environment objectEntity = RepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
		Collection<String> members = Collections2.transform(objectEntity.getMembers(), new Function<Container, String>() {
			public String apply(Container input) {
				return input.getId();
			}
		});
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, members, action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, members, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	Permission getPermission() {
		return Permission.DEPLOY_UPGRADE;
	}
}
