package com.xebialabs.deployit.security.permission;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class UndeploymentHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.UNDEPLOY, user, action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, newArrayList("Environments", "Infrastructure"), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
		permission(Permission.UNDEPLOY, user, onConfigurationItem, action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
		final Environment objectEntity = RepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, Collections2.transform(objectEntity.getMembers(), new Function<Container, String>() {
			public String apply(Container input) {
				return input.getId();
			}
		}), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	Permission getPermission() {
		return Permission.UNDEPLOY;
	}
}
