package com.xebialabs.deployit.security.permission;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

/**
 * Read is the single Permission which can be denied at the moment, therefore it has some more complex logic. Please look carefully at the integration tests
 * if you change something here.
 */
public class ReadHandler extends PermissionHandler {

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		permission(Permission.READ, user, onConfigurationItem, action);
		privileges(newArrayList(JCR_READ), user, onConfigurationItem, action);
	}

	@Override
	public void deny(String user, List<String> onConfigurationItems) {
		for (String onConfigurationItem : onConfigurationItems) {
			// Grant a read permission, so that revoke works.
			// This is allowed because no-one checks the read permission from the outside
			// This is handled by JCR underwater.
			permission(Permission.READ, user, onConfigurationItem, Action.GRANT);
			privileges(newArrayList(JCR_READ), user, onConfigurationItem, Action.DENY);
		}
	}

	@Override
	Permission getPermission() {
		return Permission.READ;
	}
}
