package com.xebialabs.deployit.security.permission;

public enum Permission {
	LOGIN("login"),
	READ("read", new ReadHandler()),
	IMPORT_INITIAL("import#initial", new InitialImportHandler()),
	IMPORT_UPGRADE("import#upgrade", new UpgradeImportHandler()),
	DEPLOY_INITIAL("deploy#initial", new InitialDeploymentHandler()),
	DEPLOY_UPGRADE("deploy#upgrade", new UpgradeDeploymentHandler()),
	DISCOVERY("discovery", new DiscoveryHandler()),
	UNDEPLOY("deploy#undeploy", new UndeploymentHandler()),
	EDIT_REPO("repo#edit", new EditRepositoryHandler()),
	TASK_MOVESTEP("task#move_step"),
	TASK_SKIPSTEP("task#skip_step"),
	CONTROLTASK_EXECUTE("controltask#execute");

	private PermissionHandler permissionHandler;
	private String permissionName;

	Permission(String permissionName) {
		this.permissionName = permissionName;
		this.permissionHandler = new GlobalPermissionHandler() {
			@Override
			Permission getPermission() {
				return Permission.this;
			}
		};
	}

	Permission(String permissionName, PermissionHandler permissionHandler) {
		this.permissionName = permissionName;
		this.permissionHandler = permissionHandler;
	}

	public static Permission find(String permissionName) {
		for (Permission permission : values()) {
			if (permission.permissionName.equals(permissionName)) {
				return permission;
			}
		}
		return null;
	}

	public PermissionHandler getPermissionHandler() {
		return permissionHandler;
	}

	public String getPermissionName() {
		return permissionName;
	}
}
