package com.xebialabs.deployit.security.permission;

import static com.google.common.collect.Lists.newArrayList;

import java.util.ArrayList;

public class EditRepositoryHandler extends PermissionHandler {
	private static final ArrayList<String> EDIT_PRIVILEGES =
			newArrayList(JCR_MODIFY_PROPERTIES, JCR_ADD_CHILD_NODES, JCR_NODE_TYPE_MANAGEMENT, JCR_REMOVE_CHILD_NODES, JCR_REMOVE_NODE, JCR_VERSION_MANAGEMENT);

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		permission(getPermission(), user, onConfigurationItem, action);
		privileges(EDIT_PRIVILEGES, user, onConfigurationItem, action);
	}

	@Override
	protected void handle(String user, Action action) {
		permission(getPermission(), user, action);
		privileges(EDIT_PRIVILEGES, user, "", action);
	}

	@Override
	Permission getPermission() {
		return Permission.EDIT_REPO;
	}
}
