package com.xebialabs.deployit.security;

import static com.xebialabs.deployit.jcr.JcrConstants.ADMIN_PASSWORD;
import static com.xebialabs.deployit.jcr.JcrConstants.ADMIN_USERNAME;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;

public class SecurityTemplate {

	public static <T> T executeAsAdmin(final SecurityCallback<T> callback) {
		return executeAs(ADMIN_USERNAME, ADMIN_PASSWORD, callback);
	}

	public static <T> T executeAs(final String username, final String password, final JcrTemplate jcrTemplate, final JcrCallback<T> callback) {
		return executeAs(username, password, new SecurityCallback<T>() {
			@Override
			public T doAs() {
				return jcrTemplate.execute(callback);
			}
		});
	}

	public static <T> T executeAs(final UsernameAndPasswordCredentials credentials, final SecurityCallback<T> callback) {
		return executeAs(credentials.getUsername(), credentials.getPassword(), callback);
	}

	public static <T> T executeAs(final String username, final String password, final SecurityCallback<T> callback) {
		final Authentication origAuthentication = setCredentials(username, password);
		try {
			return callback.doAs();
		} finally {
			restoreAuthentication(origAuthentication);
		}

	}

	public static Authentication setCredentials(final String username, final String password) {
		final SecurityContext context = SecurityContextHolder.getContext();
		final Authentication origAuthentication = context.getAuthentication();
		context.setAuthentication(new UsernameAndPasswordCredentials(username, password));
		return origAuthentication;
	}

	public static void restoreAuthentication(final Authentication origAuthentication) {
		SecurityContextHolder.getContext().setAuthentication(origAuthentication);
	}

}
